% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{nso_fetch}
\alias{nso_fetch}
\title{Fetch a query and return a tibble}
\usage{
nso_fetch(
  x,
  labels = c("code", "en", "mn", "both"),
  value_name = getOption("mongolstats.value_name", "value"),
  include_raw = getOption("mongolstats.attach_raw", FALSE)
)
}
\arguments{
\item{x}{An \code{nso_query} object.}

\item{labels}{One of "code", "en", "mn", or "both" (mapped to internal API).}

\item{value_name}{Name of the numeric value column in the result (default: "value").}

\item{include_raw}{If TRUE, attach the raw PX payload as attribute \code{px_raw}.}
}
\value{
A tibble.
}
\description{
Executes an \code{nso_query} and returns a tidy tibble with one column per
dimension and a numeric \code{value} column. Use \code{labels} to add \verb{_en}/\verb{_mn}
columns for each dimension.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
q <- nso_query("DT_NSO_0300_001V2", list(Year = "2023"))
data <- nso_fetch(q)
head(data)
\dontshow{\}) # examplesIf}
}
