% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_int.R
\name{calc_F}
\alias{calc_F}
\title{Newton-Raphson search for fishing mortality}
\usage{
calc_F(
  Cobs,
  N,
  sel,
  wt,
  M,
  q_fs,
  delta = 1,
  na = dim(N)[1],
  nr = dim(N)[2],
  ns = dim(N)[3],
  nf = length(Cobs),
  Fmax = 2,
  nitF = 5L,
  trans = c("log", "logit")
)
}
\arguments{
\item{Cobs}{Observed catch. Matrix \verb{[f, r]}}

\item{N}{Stock abundance at the beginning of the time step. Array \verb{[a, r, s]}}

\item{sel}{Selectivity. Array \verb{[a, f, s]}}

\item{wt}{Fishery weight at age. Array \verb{[a, f, s]}}

\item{M}{Instantaneous natural mortality. Units of per year \verb{[a, s]}}

\item{q_fs}{Relative catchability of stock \code{s} for fleet \code{f}. Defaults to 1 if missing. Matrix \verb{[f, s]}}

\item{delta}{Numeric, the duration of time in years corresponding to the observed catch, e.g., 0.25 is a quarterly time step.}

\item{na}{Integer, number of age classes}

\item{nr}{Integer, number of regions}

\item{ns}{Integer, number of stocks}

\item{nf}{Integer, number of fleets}

\item{Fmax}{Numeric, the maximum Findex value}

\item{nitF}{Integer, number of iterations for the Newton-Raphson routine}

\item{trans}{Whether to perform the search in log or logit space}
}
\value{
A list containing:
\itemize{
\item \code{F_afrs} Fishing mortality array
\item \code{F_ars} Fishing mortality array (summed across fleets)
\item \code{Z_ars} Total mortality array
\item \code{F_index} Index of fishing mortality. Matrix \verb{[f, r]}
\item \code{CB_frs} Catch (biomass) array
\item \code{CN_afrs} Catch (abundance) array
\item \code{VB_afrs} Vulnerable biomass at the beginning of the time step. Array
\item \code{penalty} Penalty term returned by \code{\link[=posfun]{posfun()}} when \code{F_index} exceeds \code{Fmax}
\item \code{fn} Difference between predicted and observed catch at the last iteration. Matrix \verb{[f, r]}
\item \code{gr} Gradient of \code{fn} with respect to \code{F_index} in either log or logit space at the last iteration. Vector by \verb{[f, r]}
}
}
\description{
Performs a root finding routine to find the index of F that minimizes the difference between
observed catch and the value predicted by the Baranov equation.
}
\details{
The predicted catch for fleet \code{f} in region \code{r} is
\deqn{
C^{\textrm{pred}}_{f,r} = \sum_s \sum_a v_{a,f,s} q_{f,s} F_{f,r} \dfrac{1 - \exp(-Z_{a,r,s})}{Z_{a,r,s}} N_{a,r,s} w_{a,f,s}
}

The Newton-Raphson routine minimizes \eqn{f(x_{f,r}) = C_{f,r}^{\textrm{pred}} - C_{f,r}^{\textrm{obs}}}.

If \code{trans = "log"}, \eqn{F_{f,r} = \exp(x_{f,r})}.

If \code{trans = "logit"}, \eqn{F_{f,r} = F_{\textrm{max}}/(1 + \exp(x_{f,r}))}.

The gradient with respect to \eqn{\vec{x}} is
\deqn{
f'(x_{f,r}) = \sum_s \sum_a v_{a,f,s} q_{f,s} N_{a,r,s} w_{a,f,s} \left(\dfrac{\alpha\gamma}{\beta}\right)'
}

\deqn{
\left(\dfrac{\alpha\gamma}{\beta}\right)' = \dfrac{(\alpha\gamma' + \alpha'\gamma)\beta - \alpha\gamma\beta'}{\beta^2}
}

where

\tabular{l}{
\eqn{\alpha_{f,r} = F_{f,r}} \cr
\eqn{\beta_{a,r,s} = Z_{a,r,s} = M_{a,s} + \sum_f v_{a,f,s} q_{f,s} F_{f,r}} \cr
\eqn{\gamma_{a,r,s} = 1 - \exp(-Z_{a,r,s})} \cr
\eqn{\beta'_{a,f,r,s} = v_{a,f} q_{f,s} \alpha'_{f,r}} \cr
\eqn{\gamma'_{a,f,r,s} = \exp(-Z_{a,r,s})\beta'_{a,f,r,s}}
}

If \code{trans = "log"}, \eqn{\alpha'_{f,r} = \alpha_{f,r}}.

If \code{trans = "logit"}, \eqn{\alpha'_{f,r} = F_{\textrm{max}}\exp(-x_{f,r})/(1 + \exp(-x_{f,r}))^2}.

This function solves for \eqn{\vec{x}} by iterating until \eqn{f(\vec{x})} approaches zero, where the vector arrow
indexes over fleet and region. In iteration \eqn{i+1}:
\deqn{\vec{x}_{i+1} = \vec{x}_i - \dfrac{f(\vec{x}_i)}{f'(\vec{x}_i)}}.
}
\author{
Q. Huynh
}
