% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuromaps.R
\name{fetch_neuromaps_annotation}
\alias{fetch_neuromaps_annotation}
\title{Download a neuromaps annotation}
\usage{
fetch_neuromaps_annotation(
  source,
  desc,
  space,
  density = NULL,
  resolution = NULL,
  hemisphere = NULL,
  data_dir = neuromaps_cache_dir(),
  overwrite = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{source}{Data source identifier (e.g. \code{"abagen"}, \code{"beliveau"}).}

\item{desc}{Map descriptor key (e.g. \code{"genepc1"}, \code{"feobv"}).}

\item{space}{Coordinate space (e.g. \code{"fsaverage"}, \code{"MNI152"}, \code{"fsLR"}).}

\item{density}{Surface vertex density (e.g. \code{"10k"}, \code{"164k"}). Mutually
exclusive with \code{resolution}.}

\item{resolution}{Volume voxel resolution (e.g. \code{"1mm"}, \code{"2mm"}). Mutually
exclusive with \code{density}.}

\item{hemisphere}{Hemisphere (\code{"L"} or \code{"R"}).}

\item{data_dir}{Directory for cached downloads. Defaults to
\code{neuromaps_cache_dir()}.}

\item{overwrite}{Re-download even if cached file exists.}

\item{verbose}{Print progress messages.}
}
\value{
Character vector of downloaded file path(s).
}
\description{
Download brain map annotation files from the neuromaps OSF repository.
Surface annotations return two files (left and right hemispheres),
volume annotations return one.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
fetch_neuromaps_annotation("abagen", "genepc1", "fsaverage", density = "10k")
\dontshow{\}) # examplesIf}
}
