% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_names.R
\name{var_names}
\alias{var_names}
\title{Extract variable names from predicate names}
\usage{
var_names(x)
}
\arguments{
\item{x}{A character vector of predicate names.}
}
\value{
A character vector containing the \verb{<varname>} parts of predicate
names in \code{x}. If an element does not contain \code{=}, the entire string is
returned as is. If \code{x} is \code{NULL}, the function returns \code{NULL}. If \code{x} has
length zero (\code{character(0)}), the function returns \code{character(0)}.
}
\description{
This function extracts the variable part from a character vector of
predicate names. Each element of \code{x} is expected to follow the pattern
\verb{<varname>=<value>}, where \verb{<varname>} is a variable name and \verb{<value>} is
the associated value.

If an element does not contain an equal sign (\code{=}), the entire string is
returned unchanged.
}
\details{
This function is the counterpart to \code{\link[=values]{values()}}, which extracts the value
part of predicates. Together, \code{var_names()} and \code{\link[=values]{values()}} provide a
convenient way to split predicate strings into their variable and value
components.
}
\examples{
var_names(c("a=1", "a=2", "b=x", "b=y"))
# returns c("a", "a", "b", "b")

var_names(c("a", "b=3"))
# returns c("a", "b")

var_names(character(0))
# returns character(0)

var_names(NULL)
# returns character(0)

}
\seealso{
\code{\link[=values]{values()}}
}
\author{
Michal Burda
}
