% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{pathling_with_column}
\alias{pathling_with_column}
\title{Add a FHIRPath-derived column to a DataFrame}
\usage{
pathling_with_column(df, pc, resource_type, expression, column)
}
\arguments{
\item{df}{A \code{tbl_spark} containing FHIR resource data.}

\item{pc}{The PathlingContext object.}

\item{resource_type}{A string containing the FHIR resource type code (e.g., "Patient",
"Observation").}

\item{expression}{A FHIRPath expression to evaluate (e.g., "name.given.first()").}

\item{column}{The name of the new column to add.}
}
\value{
A \code{tbl_spark} with the new column added.
}
\description{
Evaluates a FHIRPath expression and adds the result as a named column to a \code{tbl_spark},
returning the augmented \code{tbl_spark}. The DataFrame must be the first argument to enable
piping with \code{\%>\%}. Multiple calls can be chained to add several columns.
}
\examples{
\dontrun{
pc <- pathling_connect()
data_source <- pc \%>\% pathling_read_ndjson(pathling_examples("ndjson"))
patients <- data_source \%>\% ds_read("Patient")

# Add a single column.
result <- patients \%>\%
  pathling_with_column(pc, "Patient", "name.given.first()", column = "given_name")

# Chain multiple columns.
result <- patients \%>\%
  pathling_with_column(pc, "Patient", "name.given.first()", column = "given_name") \%>\%
  pathling_with_column(pc, "Patient", "gender", column = "gender_value") \%>\%
  dplyr::select(id, given_name, gender_value)

pathling_disconnect(pc)
}
}
\seealso{
Other context functions: 
\code{\link{pathling_evaluate_fhirpath}()},
\code{\link{pathling_fhirpath_to_column}()},
\code{\link{pathling_filter}()},
\code{\link{pathling_search_to_column}()}
}
\concept{context functions}
