% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perumammals_api.R
\name{found_in_peru}
\alias{found_in_peru}
\title{Quick check: Is species found in Peru?}
\usage{
found_in_peru(splist, exact_only = FALSE)
}
\arguments{
\item{splist}{Character vector of species names}

\item{exact_only}{Logical. If TRUE, only exact matches return TRUE (default: FALSE)}
}
\value{
Logical vector (TRUE = found, FALSE = not found)
}
\description{
Simplified boolean check for species presence in Peru mammals database.
Useful for filtering and logical operations.
}
\examples{

species <- c("Panthera onca", "Tremarctos orrnatus",
             "Tremarctos orrnatos", "Felis catus")

# Check presence (includes fuzzy matches)
found_in_peru(species)

tibble::tibble(splist = species) |>
 dplyr::mutate(endemic = found_in_peru(splist))


}
