% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_fuzzy_match.R
\name{fuzzy_match_genus}
\alias{fuzzy_match_genus}
\title{Fuzzy Match Genus Name Against Peru Mammals Database}
\usage{
fuzzy_match_genus(df, target_df = NULL)
}
\arguments{
\item{df}{A data frame containing the genus names to be matched.
Must include column: Orig.Genus}

\item{target_df}{A data frame representing peru_mammals database.
Must include column: genus}
}
\value{
A tibble with two additional columns:
\itemize{
\item \code{fuzzy_match_genus}: Logical indicating if genus was matched
\item \code{fuzzy_genus_dist}: Numeric distance for each match (lower = better)
\item \code{Matched.Genus}: The matched genus name
}
}
\description{
Performs fuzzy matching of genus names against the peru_mammals database
using string distance (Levenshtein) to account for slight spelling variations.
Maximum distance is set to 1 character difference.

This implementation uses a two-step approach to avoid warnings when no matches
are found:
\enumerate{
\item Perform stringdist_left_join to get all candidates
\item Split into valid (finite distance) and invalid (NA distance)
\item Process only valid matches to find best candidates
}
}
\details{
If multiple genera match with the same string distance (ambiguous matches),
a warning is issued and the first match is automatically selected. To
examine ambiguous matches, use \code{get_ambiguous_matches(result, type = "genus")}.

Ambiguous match information is stored as an attribute and includes:
\itemize{
\item Original genus
\item All matched genera with tied distances
\item Family information from peru_mammals
\item Number of species per genus
}
}
\keyword{internal}
