% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adtr_onco.R
\docType{data}
\name{adtr_onco}
\alias{adtr_onco}
\title{Tumor Results Analysis for Oncology}
\format{
A data frame with 99 columns:
\describe{
\item{ STUDYID }{Study Identifier}
\item{ USUBJID }{Unique Subject Identifier}
\item{ SUBJID }{Subject Identifier for the Study}
\item{ SITEID }{Study Site Identifier}
\item{ COUNTRY }{Country}
\item{ DOMAIN }{Domain Abbreviation}
\item{ RFSTDTC }{Subject Reference Start Date/Time}
\item{ RFENDTC }{Subject Reference End Date/Time}
\item{ RFXSTDTC }{Date/Time of First Study Treatment}
\item{ RFXENDTC }{Date/Time of Last Study Treatment}
\item{ RFPENDTC }{Date/Time of End of Participation}
\item{ SCRFDT }{Screen Failure Date}
\item{ FRVDT }{Final Retrieval Visit Date}
\item{ DTHDTC }{Date/Time of Death}
\item{ DTHADY }{Relative Day of Death}
\item{ DTHFL }{Subject Death Flag}
\item{ LDDTHELD }{Elapsed Days from Last Dose to Death}
\item{ LDDTHGR1 }{Last Dose to Death - Days Elapsed Grp 1}
\item{ DTH30FL }{Death Within 30 Days of Last Trt Flag}
\item{ DTHA30FL }{Death After 30 Days from Last Trt Flag}
\item{ DTHDOM }{Domain for Date of Death Collection}
\item{ DTHB30FL }{Death Within 30 Days of First Trt Flag}
\item{ ASEQ }{Analysis Sequence Number}
\item{ REGION1 }{Geographic Region 1}
\item{ DMDTC }{Date/Time of Collection}
\item{ DMDY }{Study Day of Collection}
\item{ AGE }{Age}
\item{ AGEU }{Age Units}
\item{ AGEGR1 }{Pooled Age Group 1}
\item{ SEX }{Sex}
\item{ RACE }{Race}
\item{ RACEGR1 }{Pooled Race Group 1}
\item{ ETHNIC }{Ethnicity}
\item{ SAFFL }{Safety Population Flag}
\item{ PDFL }{Pharmacodynamic Analysis Set Flag}
\item{ ARM }{Description of Planned Arm}
\item{ ARMCD }{Planned Arm Code}
\item{ ACTARM }{Description of Actual Arm}
\item{ ACTARMCD }{Actual Arm Code}
\item{ TRT01P }{Planned Treatment for Period 01}
\item{ TRT01A }{Actual Treatment for Period 01}
\item{ TRTSDT }{Date of First Exposure to Treatment}
\item{ TRTSDTM }{Datetime of First Exposure to Treatment}
\item{ TRTSTMF }{Time of First Exposure Imput. Flag}
\item{ TRTEDT }{Date of Last Exposure to Treatment}
\item{ TRTEDTM }{Datetime of Last Exposure to Treatment}
\item{ TRTETMF }{Time of Last Exposure Imput. Flag}
\item{ EOSSTT }{End of Study Status}
\item{ EOSDT }{End of Study Date}
\item{ RFICDTC }{Date/Time of Informed Consent}
\item{ RANDDT }{Date of Randomization}
\item{ LSTALVDT }{Date Last Known Alive}
\item{ TRTDURD }{Total Treatment Duration (Days)}
\item{ DTHDT }{Date of Death}
\item{ DTHCAUS }{Cause of Death}
\item{ DTHCGR1 }{Cause of Death Reason 1}
\item{ ADT }{Analysis Date}
\item{ ADY }{Analysis Relative Day}
\item{ ADTF }{Analysis Date Imputation Flag}
\item{ AVISIT }{Analysis Visit}
\item{ AVISITN }{Analysis Visit (N)}
\item{ PARAM }{Parameter}
\item{ PARAMCD }{Parameter Code}
\item{ PARCAT1 }{Parameter Category 1}
\item{ PARCAT2 }{Parameter Category 2}
\item{ PARCAT3 }{Parameter Category 3}
\item{ AVAL }{Analysis Value}
\item{ BASE }{Baseline Value}
\item{ CHG }{Change from Baseline}
\item{ PCHG }{Percent Change from Baseline}
\item{ NADIR }{NADIR}
\item{ CHGNAD }{Change from NADIR}
\item{ PCHGNAD }{Percent Change from NADIR}
\item{ ABLFL }{Baseline Record Flag}
\item{ ANL01FL }{Analysis Flag 01}
\item{ ANL02FL }{Analysis Flag 02}
\item{ ANL03FL }{Analysis Flag 03}
\item{ ANL04FL }{Analysis Flag 04}
\item{ TRSEQ }{Sequence Number}
\item{ TRGRPID }{Group ID}
\item{ TRLNKID }{Link ID}
\item{ TRTESTCD }{Tumor/Lesion Assessment Short Name}
\item{ TRTEST }{Tumor/Lesion Assessment Test Name}
\item{ TRORRES }{Result or Finding in Original Units}
\item{ TRORRESU }{Original Units}
\item{ TRSTRESC }{Character Result/Finding in Std Format}
\item{ TRSTRESN }{Numeric Result/Finding in Standard Units}
\item{ TRSTRESU }{Standard Units}
\item{ TREVAL }{Evaluator}
\item{ TREVALID }{Evaluator Identifier}
\item{ TRACPTFL }{Accepted Record Flag}
\item{ VISITNUM }{Visit Number}
\item{ VISIT }{Visit Name}
\item{ TRDTC }{Date/Time of Tumor/Lesion Measurement}
\item{ TULOC }{Location of the Tumor/Lesion}
\item{ TULOCGR1 }{Tumor Site Group 1}
\item{ LSEXP }{Lesion IDs Expected}
\item{ LSASS }{Lesion IDs Assessed}
\item{ DTHDTF }{Date of Death Imputation Flag}
}
}
\source{
Generated from admiralonco package (template ad_adtr.R).
}
\usage{
adtr_onco
}
\description{
Tumor Results Analysis for Oncology
}
\details{
Contains a set of 11 unique Parameter Codes and Parameters: \tabular{ll}{
\strong{PARAMCD} \tab \strong{PARAM} \cr
LDIAM1  \tab Target Lesion 1 Analysis Diameter              \cr
LDIAM2  \tab Target Lesion 2 Analysis Diameter              \cr
LDIAM3  \tab Target Lesion 3 Analysis Diameter              \cr
LDIAM4  \tab Target Lesion 4 Analysis Diameter              \cr
LDIAM5  \tab Target Lesion 5 Analysis Diameter              \cr
NLDIAM1 \tab Target Lesion 1 Analysis Perpendicular         \cr
NLDIAM2 \tab Target Lesion 2 Analysis Perpendicular         \cr
NLDIAM3 \tab Target Lesion 3 Analysis Perpendicular         \cr
NLDIAM4 \tab Target Lesion 4 Analysis Perpendicular         \cr
NLDIAM5 \tab Target Lesion 5 Analysis Perpendicular         \cr
SDIAM   \tab Target Lesions Sum of Diameters by Investigator
}
}
\examples{
data("adtr_onco")
}
\references{
None
}
\keyword{dataset}
\keyword{oncology}
