% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phinterval.R
\name{hole}
\alias{hole}
\title{Create a hole phinterval}
\usage{
hole(n = 1L, tzone = "")
}
\arguments{
\item{n}{\verb{[integer(1)]}

The number of hole elements to create. Must be a positive whole number.}

\item{tzone}{\verb{[character(1)]}

A time zone to display the \verb{<phinterval>} in. Defaults to \code{""}.}
}
\value{
A \verb{<phinterval>} vector of length \code{n} where each element is a \verb{<hole>}.
}
\description{
\code{hole()} creates a \verb{<phinterval>} vector where each element is a hole (an
empty set of time spans).
}
\details{
A hole is a phinterval element with zero time spans, representing an empty
interval. Holes are useful as placeholders or for representing the absence
of time periods in interval algebra operations.
}
\examples{
# Create a single hole
hole()

# Create multiple holes
hole(3)

# Specify time zone
hole(tzone = "UTC")

# Holes can be combined with other phintervals
jan <- phinterval(as.Date("2000-01-01"), as.Date("2000-02-01"))
c(jan, hole(), jan)

}
