% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params}
\alias{params}
\alias{parameters}
\alias{arguments}
\alias{args}
\title{Parameter Descriptions for phinterval Package}
\arguments{
\item{phint1, phint2}{\verb{[phinterval / Interval]}

A pair of \verb{<phinterval>} or \verb{<Interval>} vectors. \code{phint1} and \code{phint2}
are recycled to a common length using vctrs-style recycling.}

\item{phint}{\verb{[phinterval / Interval]}

A \verb{<phinterval>} or \verb{<Interval>} vector.}

\item{bounds}{\verb{["[]" / "()"]}

Whether span endpoints are inclusive or exclusive:
\itemize{
\item \code{"[]"} (default): Closed intervals - both endpoints are included
\item \code{"()"}: Open intervals - both endpoints are excluded
}

This affects adjacency and overlap detection. For example, with \code{bounds = "[]"},
the intervals \verb{[1, 5]} and \verb{[5, 10]} are considered adjacent (they share the
endpoint 5), while with \code{bounds = "()"}, \verb{(1, 5)} and \verb{(5, 10)} are disjoint
(neither includes 5).}
}
\value{
The value \code{NULL}.
}
\description{
Default parameter descriptions which may be overridden in individual
functions.
}
\keyword{internal}
