% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svdpc.fit.R
\name{nipalspc.fit}
\alias{nipalspc.fit}
\title{NIPALS PCR with missing values}
\usage{
nipalspc.fit(
  X,
  Y,
  ncomp,
  center = TRUE,
  stripped = FALSE,
  maxiter = 500,
  tol = 1e-06,
  ...
)
}
\arguments{
\item{X}{numeric matrix (or coercible) of predictors. Missing values are
allowed and handled internally.}

\item{Y}{numeric matrix (or coercible) of responses. Missing values are also
handled internally during the final regression step.}

\item{ncomp}{number of PCR components to extract.}

\item{center}{logical. If \code{TRUE} both \code{X} and \code{Y} are
centered column-wise (ignoring missing entries).}

\item{stripped}{logical. When \code{TRUE} only the coefficients and mean
vectors are returned for faster use in resampling.}

\item{maxiter}{maximum number of inner iterations per component.}

\item{tol}{convergence tolerance used when the direction vector stabilizes.}

\item{...}{currently ignored.}
}
\value{
A list mirroring the return value of \code{svdpc.fit} but computed
via the NA-robust NIPALS PCR updates.
}
\description{
A NIPALS-based PCR that tolerates missing entries in both
predictors and responses by only using observed cells when updating scores
and loadings.  It follows the same API as \code{svdpc.fit} so it can be used
whenever low-level PCR needs to handle incomplete data.
}
