% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmrm_simulate_slowing_proportional.R
\name{pmrm_simulate_slowing_proportional}
\alias{pmrm_simulate_slowing_proportional}
\title{Simulate proportional slowing model.}
\usage{
pmrm_simulate_slowing_proportional(
  patients = 300,
  visit_times = seq(from = 0, to = 4, by = 1),
  spline_knots = visit_times,
  spline_method = c("natural", "fmm"),
  tau = 0,
  alpha = log(spline_knots + 1),
  beta = c(0, 0.1, 0.2),
  gamma = numeric(0L),
  sigma = rep(1, length(visit_times)),
  rho = rep(0, length(visit_times) * (length(visit_times) - 1L)/2L)
)
}
\arguments{
\item{patients}{Positive integer scalar,
total number of patients in the output dataset.
Patients are allocated (roughly) uniformly across the study arms.}

\item{visit_times}{Numeric vector, the continuous scheduled time
after randomization of each study visit.}

\item{spline_knots}{Numeric vector of spline knots on the continuous scale,
including boundary knots.}

\item{spline_method}{Character string, spline method to use for the base model.
Must be \code{"natural"} or \code{"fmm"}.
See \code{\link[stats:splinefun]{stats::splinefun()}} for details.}

\item{tau}{Positive numeric scalar, standard deviation for jittering
the simulated time points.
Defaults to 0 so that the observed continuous times are just the
scheduled visit times.}

\item{alpha}{Numeric vector of spline coefficients for simulating
the mean function \verb{f(t_\{ij\} | spline_knots, alpha)}.
Must have \code{length(spline_knots)} elements.}

\item{beta}{Numeric vector with one element per study arm
(including the control arm).
See \code{vignette("models", package = "pmrm")} for details on this parameter.}

\item{gamma}{Numeric vector of model coefficients for covariate adjustment.
The simulation functions in \code{pmrm} simulate \code{length(gamma)} columns for
the covariate adjustment model matrix \code{W}.
Set to \code{numeric(0)} to omit covariates.}

\item{sigma}{A positive numeric vector of visit-level standard deviation
parameters.}

\item{rho}{A finite numeric vector of correlation parameters.
Must have length \code{J * (J - 1) / 2}, where \code{J} is \code{length(visit_times)}.
The full covariance matrix \code{Sigma} is given by
\code{diag(sigma) \%*\% RTMB::unstructured(length(sigma))$corr(rho) \%*\% diag(sigma)}.}
}
\value{
A \code{tibble} of clinical data simulated from the slowing model.
See the "Simulated data" section of this help file for details.
}
\description{
Simulate a dataset from the proportional slowing model.
}
\details{
See \code{vignette("models", package = "pmrm")} for details.
}
\section{Simulated data}{

The datasets returned from the simulation functions
have one row per patient visit and the following columns
which conform to the notation from \code{vignette("models", package = "pmrm")}:
\itemize{
\item \code{patient}: Character vector of patient ID labels.
\item \code{visit}: Ordered factor of clinical visits with labels included.
\code{min(visit)} indicates the baseline visit.
\item \code{arm}: Ordered factor of study arms with visits included.
\code{min(arm)} indicates the control arm.
\item \code{i}: integer ID of each patient.
\item \code{j}: integer ID of each clinical visit.
\code{j == 1} at baseline.
\item \code{k}: integer ID of the study arm of patient \code{i}.
\code{k == 1} for the control arm.
\item \code{y}: clinical outcomes.
\item \code{t}: observed continuous time since baseline.
\item \code{beta}: the scalar component of the treatment effect parameter
\code{beta} defined for patient \code{i}.
\item \code{mu}: expected clinical outcome at the given patient visit.
\item \verb{w_*}: columns of the covariate adjustment model matrix \code{W}.
\item \code{e}: residuals.
}
}

\examples{
  pmrm_simulate_slowing_proportional()
}
\seealso{
Other simulations: 
\code{\link{pmrm_simulate_decline_nonproportional}()},
\code{\link{pmrm_simulate_decline_proportional}()},
\code{\link{pmrm_simulate_slowing_nonproportional}()}
}
\concept{simulations}
