% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mlv_teams}
\alias{mlv_teams}
\title{Major League Volleyball Teams}
\format{
A data frame with 8 rows and 5 variables:
\describe{
\item{city}{Team city name}
\item{mascot}{Team mascot name}
\item{name}{Full team name (city + mascot)}
\item{slug}{URL slug used in MLV website URLs}
\item{first_year}{Year that team started in MLV}
}
}
\source{
\url{https://provolleyball.com}
}
\usage{
mlv_teams
}
\description{
A dataset containing information about Major League Volleyball (MLV) teams,
including team names, cities, mascots, URL slugs, and first year used for web scraping.
}
\details{
This dataset is used internally by the package functions to map
user-provided team names to the appropriate URL slugs needed for web scraping
the MLV website.
}
\examples{
mlv_teams

}
\seealso{
Other datasets: 
\code{\link{au_player_data}},
\code{\link{lovb_player_data}},
\code{\link{lovb_team_data}},
\code{\link{lovb_teams}},
\code{\link{mlv_player_data}},
\code{\link{mlv_team_data}}
}
\concept{datasets}
\keyword{datasets}
