% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficacy_table.R
\name{efficacy_table}
\alias{efficacy_table}
\title{Create Regulatory-Style Efficacy Summary Table}
\usage{
efficacy_table(
  pool_obj,
  title = NULL,
  subtitle = NULL,
  digits = 2,
  ci_level = NULL,
  arm_labels = NULL,
  pval_digits = 3,
  pval_threshold = 0.001,
  font_family = NULL,
  font_size = NULL,
  row_padding = NULL,
  ...
)
}
\arguments{
\item{pool_obj}{A pooled analysis object of class \code{"pool"}, typically
obtained from \code{\link[rbmi:pool]{rbmi::pool()}} after calling \code{\link[=analyse_mi_data]{analyse_mi_data()}}.}

\item{title}{Optional character string for the table title.}

\item{subtitle}{Optional character string for the table subtitle.}

\item{digits}{Integer. Number of decimal places for estimates and standard
errors. Default is 2.}

\item{ci_level}{Numeric. Confidence level for CI column labeling. If \code{NULL}
(the default), extracted from \code{pool_obj$conf.level}. Falls back to 0.95 if
neither is available.}

\item{arm_labels}{Named character vector with elements \code{"ref"} and \code{"alt"}
providing custom labels for the reference and treatment arms. If \code{NULL}
(the default), uses \code{"Reference"} and \code{"Treatment"}.}

\item{pval_digits}{Integer. Number of decimal places for p-values. Default
is 3.}

\item{pval_threshold}{Numeric. P-values below this threshold are displayed
as "< threshold". Default is 0.001.}

\item{font_family}{Optional character string specifying the font family for
the table. When \code{NULL} (default), uses gt's default font. Applied via
\code{\link[gt:opt_table_font]{gt::opt_table_font()}}.}

\item{font_size}{Optional numeric value specifying the table font size in
pixels. When \code{NULL} (default), uses gt's default size. Applied via
\code{\link[gt:tab_options]{gt::tab_options()}}.}

\item{row_padding}{Optional numeric value specifying the vertical padding
for data rows in pixels. When \code{NULL} (default), uses gt's default padding.
Smaller values (e.g., 2-3) create compact regulatory-style tables.}

\item{...}{Additional arguments passed to \code{\link[gt:gt]{gt::gt()}}.}
}
\value{
A gt table object of class \code{gt_tbl}.
}
\description{
Takes an rbmi pool object and produces a publication-ready gt table in the
style of CDISC/ICH Table 14.2.x. The table displays least squares means by
treatment arm, treatment differences, confidence intervals, and p-values,
organized by visit row groups.
}
\details{
This function assumes a single-parameter-per-visit pool object (the standard
output from an rbmi ANCOVA or MMRM pipeline). It internally calls
\code{\link[=tidy_pool_obj]{tidy_pool_obj()}} to parse the pool object, then constructs the gt table.

\strong{Arm labels:} Use the \code{arm_labels} parameter to customize arm names in the
table. For example, \code{arm_labels = c(ref = "Placebo", alt = "Drug A")} will
display "LS Mean (Placebo)" and "LS Mean (Drug A)" instead of the defaults.

\strong{Customization:} The returned gt object can be further customized using
standard gt piping, e.g., \code{efficacy_table(pool_obj) |> gt::tab_options(...)}.

\strong{Example output:}

\if{html}{\figure{efficacy_table-example.png}{options: width=700}}
}
\examples{
\donttest{
if (requireNamespace("gt", quietly = TRUE)) {
  library(rbmi)
  data("ADMI", package = "rbmiUtils")
  ADMI$TRT <- factor(ADMI$TRT, levels = c("Placebo", "Drug A"))
  ADMI$USUBJID <- factor(ADMI$USUBJID)
  ADMI$AVISIT <- factor(ADMI$AVISIT)

  vars <- set_vars(
    subjid = "USUBJID", visit = "AVISIT", group = "TRT",
    outcome = "CHG", covariates = c("BASE", "STRATA", "REGION")
  )
  method <- method_bayes(
    n_samples = 20,
    control = control_bayes(warmup = 20, thin = 1)
  )

  ana_obj <- analyse_mi_data(ADMI, vars, method, fun = ancova)
  pool_obj <- pool(ana_obj)

  # Basic table
  tbl <- efficacy_table(pool_obj)

  # Publication-styled table
  efficacy_table(
    pool_obj,
    title = "Table 14.2.1: ANCOVA of Change from Baseline",
    subtitle = "Mixed Model for Repeated Measures",
    arm_labels = c(ref = "Placebo", alt = "Drug A"),
    font_size = 12,
    row_padding = 4
  )
}
}

}
\seealso{
\itemize{
\item \code{\link[=tidy_pool_obj]{tidy_pool_obj()}} for the underlying data transformation
\item \code{\link[=format_pvalue]{format_pvalue()}} for p-value formatting rules
\item \code{\link[rbmi:pool]{rbmi::pool()}} to create pool objects
}
}
