% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_mi_data.R
\name{print.analysis}
\alias{print.analysis}
\title{Print Method for Analysis Objects}
\usage{
\method{print}{analysis}(x, ...)
}
\arguments{
\item{x}{An object of class \code{analysis}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Invisibly returns the input object.
}
\description{
Prints a summary of an analysis object from \code{\link[=analyse_mi_data]{analyse_mi_data()}}.
}
\examples{
\donttest{
library(rbmi)
library(rbmiUtils)
data("ADMI")

# Create analysis object
vars <- set_vars(
  subjid = "USUBJID", visit = "AVISIT", group = "TRT",
  outcome = "CHG", covariates = c("BASE", "STRATA")
)
method <- method_bayes(n_samples = 10, control = control_bayes(warmup = 10))

ana_obj <- analyse_mi_data(ADMI, vars, method, fun = function(d, v, ...) 1)
print(ana_obj)
}

}
