/*
 * Decompiled with CFR 0.152.
 */
package usf.saav.topology.merge;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Objects;
import java.util.Vector;
import org.jocl.cl_event;
import usf.saav.common.EventTimer;
import usf.saav.common.algorithm.ArrayDisjointSet;
import usf.saav.common.jocl.joclDevice;
import usf.saav.common.jocl.joclEvent;
import usf.saav.common.jocl.joclException;
import usf.saav.common.jocl.joclKernel;
import usf.saav.common.jocl.joclMemory;
import usf.saav.common.jocl.joclResourceLoader;
import usf.saav.scalarfield.ScalarField2D;
import usf.saav.topology.TopoTreeNode;
import usf.saav.topology.merge.AbstractAugmentedMergeTree;
import usf.saav.topology.merge.AbstractMergeTreeNode;

public abstract class PAugmentedMergeTree
extends AbstractAugmentedMergeTree {
    private joclDevice device;
    private joclKernel kernel_djs;
    private joclKernel kernel_cps_extract;
    private joclKernel kernel_cps_bin;
    private joclKernel kernel_cps_bin_sort;
    private joclKernel kernel_cps_propagate;
    private joclMemory d_field;
    private joclMemory d_djs;
    private joclMemory d_cps;
    private joclMemory d_scratch;
    private joclMemory d_histogram;
    ScalarField2D sf = null;
    Vector<EventTimer> events = new Vector();
    int histogramBinN = 128;
    boolean verbose = false;
    boolean operationComplete = false;
    int processed = 0;
    int invalid = 0;
    int unprocessed = 0;
    int total = 0;

    public PAugmentedMergeTree(joclDevice joclDevice2) {
        this(joclDevice2, false);
    }

    public PAugmentedMergeTree(joclDevice joclDevice2, boolean bl) {
        this.verbose = bl;
        this.device = joclDevice2;
        String string = "/usf/saav/topology/join/parallel";
        try {
            this.kernel_djs = this.device.buildProgram(new joclResourceLoader(string, "kernel_djs.cl"), "kernel_djs");
            this.kernel_cps_bin = this.device.buildProgram(new joclResourceLoader(string, "kernel_cps_bucket_sort.cl"), "kernel_cps_bucket");
            this.kernel_cps_bin_sort = this.device.buildProgram(new joclResourceLoader(string, "kernel_cps_bucket_sort.cl"), "kernel_cps_bucket_sort");
            if (this.device.getMaxWorkGroupSize() == 256L) {
                this.kernel_cps_extract = this.device.buildProgram(new joclResourceLoader(string, "kernel_cps_extract.cl"), "kernel_cps_extract_256");
                this.kernel_cps_propagate = this.device.buildProgram(new joclResourceLoader(string, "kernel_cps_propagate.cl"), "kernel_cps_propagate_256");
            } else if (this.device.getMaxWorkGroupSize() == 1024L) {
                this.kernel_cps_extract = this.device.buildProgram(new joclResourceLoader(string, "kernel_cps_extract.cl"), "kernel_cps_extract_1024");
                this.kernel_cps_propagate = this.device.buildProgram(new joclResourceLoader(string, "kernel_cps_propagate.cl"), "kernel_cps_propagate_1024");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void release() {
        if (this.sf != null) {
            this.d_field.release();
            this.d_djs.release();
            this.d_cps.release();
            this.d_scratch.release();
            this.d_histogram.release();
        }
        this.sf = null;
    }

    public void writeDJSInfo(PrintStream printStream, boolean bl) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.sf.getSize() * 4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.d_djs.enqueueReadBuffer(true, byteBuffer, new cl_event[0]);
            printStream.println(this.sf.getWidth() + " " + this.sf.getHeight());
            for (int i = 0; i < this.sf.getSize(); ++i) {
                if (bl) {
                    printStream.print("[" + i + "]" + byteBuffer.getInt() + " ");
                } else {
                    printStream.print(byteBuffer.getInt() + " ");
                }
                if (i % this.sf.getWidth() != this.sf.getWidth() - 1) continue;
                printStream.println();
            }
        }
        catch (joclException joclException2) {
            joclException2.printStackTrace();
        }
    }

    public void writeDJSHashInfo(PrintStream printStream) {
        try {
            int n;
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)this.d_djs.size());
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.d_djs.enqueueReadBuffer(true, byteBuffer, new cl_event[0]);
            int n2 = byteBuffer.getInt();
            System.out.println("heap: " + n2);
            int[] nArray = new int[2048];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = byteBuffer.getInt();
            }
            HashDJSRecord[] hashDJSRecordArray = new HashDJSRecord[n2];
            for (n = 0; n < hashDJSRecordArray.length; ++n) {
                hashDJSRecordArray[n] = new HashDJSRecord(this);
                hashDJSRecordArray[n].key = byteBuffer.getInt();
                hashDJSRecordArray[n].value = byteBuffer.getInt();
                hashDJSRecordArray[n].data = byteBuffer.getFloat();
                hashDJSRecordArray[n].next = byteBuffer.getInt();
            }
            for (n = 0; n < nArray.length; ++n) {
                int n3 = nArray[n];
                if (n3 == -1) continue;
                System.out.print("  [" + n + "] ");
                while (n3 != -1) {
                    System.out.print("[" + hashDJSRecordArray[n3].key + "->" + hashDJSRecordArray[n3].value + " (" + hashDJSRecordArray[n3].data + ")] ");
                    n3 = hashDJSRecordArray[n3].next;
                }
                System.out.println();
            }
        }
        catch (joclException joclException2) {
            joclException2.printStackTrace();
        }
    }

    public void writeCPInfo(PrintStream printStream) {
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)this.d_cps.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            this.d_cps.enqueueReadBuffer(true, byteBuffer, new cl_event[0]);
        }
        catch (joclException joclException2) {
            joclException2.printStackTrace();
        }
        CPSTransfer cPSTransfer = new CPSTransfer();
        int n = byteBuffer.getInt();
        int n2 = (n - 1) / CPSTransfer.size();
        int n3 = 0;
        printStream.println("heap pointer: " + n + " (" + n2 + " cps)");
        for (int i = 0; i < this.sf.getSize() && i < n2 * 2; ++i) {
            cPSTransfer.loadNext(byteBuffer);
            System.out.print("(" + n3 + ")");
            cPSTransfer.print(printStream);
            ++n3;
        }
        printStream.println();
    }

    public void writeScratchInfo(PrintStream printStream, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)this.d_scratch.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            this.d_scratch.enqueueReadBuffer(true, byteBuffer, new cl_event[0]);
        }
        catch (joclException joclException2) {
            joclException2.printStackTrace();
        }
        for (int i = 0; i < 2; ++i) {
            int n;
            byteBuffer.position(i * 2048 * 4);
            int n2 = byteBuffer.getInt();
            System.out.println("heap: " + n2);
            int[] nArray = new int[64];
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = byteBuffer.getInt();
            }
            HashRecord[] hashRecordArray = new HashRecord[n2];
            for (n = 0; n < hashRecordArray.length; ++n) {
                hashRecordArray[n] = new HashRecord(this);
                hashRecordArray[n].value = byteBuffer.getInt();
                hashRecordArray[n].data = byteBuffer.getInt();
                hashRecordArray[n].next = byteBuffer.getInt();
            }
            for (n = 0; n < nArray.length; ++n) {
                System.out.print("  [" + n + "] ");
                int n3 = nArray[n];
                while (n3 != -1) {
                    System.out.print("(" + hashRecordArray[n3].value + "->" + hashRecordArray[n3].data + ") ");
                    n3 = hashRecordArray[n3].next;
                }
                System.out.println();
            }
        }
    }

    public void writeStats(PrintStream printStream) {
        for (EventTimer eventTimer : this.events) {
            printStream.println("\t" + eventTimer.getName() + " execution time in milliseconds = " + eventTimer.getElapsedTimeMilliseconds() + " ms");
        }
        printStream.println("\tsaddles processed by kernel: " + this.processed);
        printStream.println("\tsaddles invaldiated by kernel: " + this.invalid);
        printStream.println("\tsaddles unprocessed by kernel: " + this.unprocessed);
        printStream.println("\tnodes in tree: " + this.total);
    }

    public void writeStatsCSVHeader(PrintStream printStream) {
        for (EventTimer eventTimer : this.events) {
            printStream.print(eventTimer.getName() + ", ");
        }
        printStream.print("saddles_processed, ");
        printStream.print("saddles_invaldiated, ");
        printStream.print("saddles_unprocessed, ");
        printStream.println("tree_size");
    }

    public void writeStatsCSV(PrintStream printStream) {
        for (EventTimer eventTimer : this.events) {
            printStream.print(eventTimer.getElapsedTimeMilliseconds() + ", ");
        }
        printStream.print(this.processed + ", ");
        printStream.print(this.invalid + ", ");
        printStream.print(this.unprocessed + ", ");
        printStream.println(this.total);
    }

    public abstract void calculate(ScalarField2D var1);

    protected void calculate(ScalarField2D scalarField2D, boolean bl) {
        ScalarField2D.Padded padded = new ScalarField2D.Padded(scalarField2D, 16, 16);
        this.events.clear();
        if (this.sf != null && this.sf.getSize() < padded.getSize()) {
            this.d_field.release();
            this.d_djs.release();
            this.d_cps.release();
            this.d_scratch.release();
            this.d_histogram.release();
            this.sf = null;
        }
        if (this.sf == null) {
            this.d_field = this.device.createBuffer("field", 4L, 4 * padded.getSize());
            this.d_djs = this.device.createBuffer("djs", 1L, Math.max(4 * padded.getSize(), 40964));
            this.d_cps = this.device.createBuffer("cps", 1L, 4 * padded.getSize() * CPSTransfer.size());
            this.d_scratch = this.device.createBuffer("scratch", 1L, 4 * padded.getSize());
            this.d_histogram = this.device.createBuffer("histogram", 1L, 4 * (3 + this.histogramBinN + this.histogramBinN));
        }
        this.sf = padded;
        EventTimer.Default default_ = new EventTimer.Default("start_to_finish");
        this.events.add(default_);
        default_.start();
        try {
            Object object;
            float[] fArray = new float[this.sf.getSize()];
            float f = Float.MAX_VALUE;
            float f2 = -3.4028235E38f;
            if (bl) {
                for (var8_9 = 0; var8_9 < fArray.length; ++var8_9) {
                    fArray[var8_9] = -this.sf.getValue(var8_9);
                    f = Math.min(f, fArray[var8_9]);
                    f2 = Math.max(f2, fArray[var8_9]);
                }
            } else {
                for (var8_9 = 0; var8_9 < fArray.length; ++var8_9) {
                    fArray[var8_9] = this.sf.getValue(var8_9);
                    f = Math.min(f, fArray[var8_9]);
                    f2 = Math.max(f2, fArray[var8_9]);
                }
            }
            joclEvent joclEvent2 = this.d_field.enqueueWriteBuffer(false, fArray);
            this.events.add(joclEvent2);
            joclEvent joclEvent3 = this.d_djs.enqueueFillBuffer(new byte[]{0});
            this.events.add(joclEvent3);
            joclEvent joclEvent4 = this.d_cps.enqueueFillBuffer(new byte[]{0});
            this.events.add(joclEvent4);
            joclEvent joclEvent5 = this.d_scratch.enqueueFillBuffer(new byte[]{0});
            this.events.add(joclEvent5);
            ByteBuffer byteBuffer = ByteBuffer.allocate(4 * (3 + this.histogramBinN * 2));
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(this.histogramBinN);
            byteBuffer.putFloat(f);
            byteBuffer.putFloat(f2);
            for (int i = 0; i < this.histogramBinN; ++i) {
                byteBuffer.putInt(0);
                byteBuffer.putInt(0);
            }
            joclEvent joclEvent6 = this.d_histogram.enqueueWriteBuffer(false, byteBuffer);
            this.events.add(joclEvent6);
            int n = 0;
            this.kernel_djs.setKernelArg(0, this.sf.getWidth());
            this.kernel_djs.setKernelArg(1, this.sf.getHeight());
            this.kernel_djs.setKernelArg(2, this.d_field);
            this.kernel_djs.setKernelArg(3, this.d_djs);
            this.kernel_djs.setKernelArg(4, 1);
            joclEvent joclEvent7 = this.kernel_djs.enqueueNDRangeKernel(new long[]{this.sf.getWidth(), this.sf.getHeight()}, joclEvent6.event, joclEvent2.event, joclEvent3.event);
            this.events.add(joclEvent7);
            this.kernel_djs.setKernelArg(4, 2);
            joclEvent joclEvent8 = this.kernel_djs.enqueueNDRangeKernel(new long[]{this.sf.getWidth(), this.sf.getHeight()}, joclEvent7.event);
            this.events.add(joclEvent8);
            n = 0;
            this.kernel_cps_extract.setKernelArg(n++, this.sf.getWidth());
            this.kernel_cps_extract.setKernelArg(n++, this.sf.getHeight());
            this.kernel_cps_extract.setKernelArg(n++, this.d_field);
            this.kernel_cps_extract.setKernelArg(n++, this.d_djs);
            this.kernel_cps_extract.setKernelArg(n++, this.d_cps);
            this.kernel_cps_extract.setKernelArg(n++, this.d_histogram);
            joclEvent joclEvent9 = this.kernel_cps_extract.enqueueNDRangeKernel(new long[]{this.sf.getWidth(), this.sf.getHeight()}, joclEvent4.event, joclEvent8.event);
            this.events.add(joclEvent9);
            n = 0;
            this.kernel_cps_bin.setKernelArg(n++, this.d_cps);
            this.kernel_cps_bin.setKernelArg(n++, this.d_histogram);
            joclEvent joclEvent10 = this.kernel_cps_bin.enqueueNDRangeKernel(new long[]{this.sf.getWidth() * this.sf.getHeight()}, joclEvent9.event);
            this.events.add(joclEvent10);
            n = 0;
            this.kernel_cps_bin_sort.setKernelArg(n++, this.d_cps);
            this.kernel_cps_bin_sort.setKernelArg(n++, this.d_histogram);
            joclEvent joclEvent11 = this.kernel_cps_bin_sort.enqueueNDRangeKernel(new long[]{this.device.getMaxWorkGroupSize() * (long)this.histogramBinN}, new long[]{this.device.getMaxWorkGroupSize()}, joclEvent10.event);
            this.events.add(joclEvent11);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            joclEvent joclEvent12 = this.d_cps.enqueueReadBuffer(true, byteBuffer2, joclEvent11.event);
            this.events.add(joclEvent12);
            int n2 = byteBuffer2.getInt();
            int n3 = (n2 - 1) / CPSTransfer.size();
            System.out.println("CPS=" + n3);
            this.kernel_cps_propagate.setKernelArg(0, this.d_cps);
            this.kernel_cps_propagate.setKernelArg(1, this.d_djs);
            this.kernel_cps_propagate.setKernelArg(3, this.d_scratch);
            this.kernel_cps_propagate.setKernelArg(4, 0);
            long l = this.device.getMaxWorkGroupSize();
            long l2 = (long)n3 + l - 1L - ((long)n3 + l - 1L) % l;
            Object object2 = joclEvent12;
            joclEvent joclEvent13 = this.d_djs.enqueueFillBuffer(Integer.MAX_VALUE, ((joclEvent)object2).event);
            this.events.add(joclEvent13);
            object2 = joclEvent13;
            joclEvent joclEvent14 = this.d_scratch.enqueueFillBuffer(new int[]{0, Integer.MAX_VALUE}, ((joclEvent)object2).event);
            this.events.add(joclEvent14);
            object2 = joclEvent14;
            int[] nArray = new int[]{0, 0};
            int n4 = 0;
            EventTimer.CombinedEvents combinedEvents = new EventTimer.CombinedEvents("event_cps_propagate");
            this.events.add(combinedEvents);
            for (int i = 1; i <= 40; ++i) {
                this.kernel_cps_propagate.setKernelArg(2, i);
                this.kernel_cps_propagate.setKernelArg(4, n4);
                object = this.kernel_cps_propagate.enqueueNDRangeKernel(new long[]{l2 - (long)n4}, ((joclEvent)object2).event);
                combinedEvents.add((EventTimer)object);
                object2 = object;
                if (i <= 1) continue;
                this.d_scratch.enqueueReadBuffer(true, (i - 1) * 8, nArray, ((joclEvent)object2).event);
                n4 = (int)((long)nArray[1] - (long)nArray[1] % l);
                System.out.println("Phase:" + (i - 1) + " {modified:" + nArray[0] + ", minimium:" + nArray[1] + "} Offset:" + n4 + " Work Remaining:" + (l2 - (long)n4));
                if (nArray[1] > n3) break;
            }
            object = ByteBuffer.allocate(n2 * 4);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            joclEvent joclEvent15 = this.d_cps.enqueueReadBuffer(true, (ByteBuffer)object, ((joclEvent)object2).event);
            this.events.add(joclEvent15);
            EventTimer.Default default_2 = new EventTimer.Default("processCPS");
            default_2.start();
            this.fastProcessCPS((ByteBuffer)object);
            default_2.stop();
            this.events.add(default_2);
        }
        catch (joclException joclException2) {
            joclException2.printStackTrace();
        }
        default_.stop();
        this.calculatePersistence();
        this.operationComplete = true;
    }

    private void fastProcessCPS(ByteBuffer byteBuffer) {
        this.processed = 0;
        this.invalid = 0;
        this.unprocessed = 0;
        this.total = 0;
        HashMap<Integer, PAugmentedMergeTreeNode> hashMap = new HashMap<Integer, PAugmentedMergeTreeNode>();
        CPSTransfer cPSTransfer = new CPSTransfer();
        int n = byteBuffer.getInt();
        int n2 = (n - 1) / CPSTransfer.size();
        System.out.println("CPS: " + n2);
        for (int i = 0; i < n2; ++i) {
            cPSTransfer.loadNext(byteBuffer);
            if (cPSTransfer.ref <= -2) {
                ++this.processed;
            } else if (cPSTransfer.ref <= 1) {
                ++this.invalid;
            } else {
                ++this.unprocessed;
            }
            if (cPSTransfer.ref < 2) continue;
            PAugmentedMergeTreeNode pAugmentedMergeTreeNode = this.createTreeNode(cPSTransfer.id);
            this.grid.add(pAugmentedMergeTreeNode);
            ++this.total;
            System.out.print(cPSTransfer.id + " -- ");
            for (int j = 0; j < cPSTransfer.ref; ++j) {
                PAugmentedMergeTreeNode pAugmentedMergeTreeNode2 = (PAugmentedMergeTreeNode)hashMap.get(cPSTransfer.setID[j]);
                System.out.print(cPSTransfer.setID[j] + ", ");
                if (pAugmentedMergeTreeNode2 == null) {
                    pAugmentedMergeTreeNode2 = this.createTreeNode(cPSTransfer.setID[j]);
                    this.grid.add(pAugmentedMergeTreeNode2);
                    ++this.total;
                }
                pAugmentedMergeTreeNode.addChild(pAugmentedMergeTreeNode2);
                hashMap.put(cPSTransfer.setID[j], pAugmentedMergeTreeNode);
            }
            System.out.println();
            this.head = pAugmentedMergeTreeNode;
        }
    }

    private void processCPS(ByteBuffer byteBuffer) {
        this.processed = 0;
        this.invalid = 0;
        this.unprocessed = 0;
        HashMap<Integer, PAugmentedMergeTreeNode> hashMap = new HashMap<Integer, PAugmentedMergeTreeNode>();
        ArrayDisjointSet arrayDisjointSet = new ArrayDisjointSet(this.sf.getSize());
        CPSTransfer cPSTransfer = new CPSTransfer();
        int n = byteBuffer.getInt();
        int n2 = (n - 1) / CPSTransfer.size();
        System.out.println("Heap Pointer: " + n + " cps:" + n2);
        for (int i = 0; i < n2; ++i) {
            int n3;
            cPSTransfer.loadNext(byteBuffer);
            if (cPSTransfer.ref <= -2) {
                ++this.processed;
            } else if (cPSTransfer.ref <= 1) {
                ++this.invalid;
            } else {
                ++this.unprocessed;
            }
            if (cPSTransfer.ref <= -2) {
                PAugmentedMergeTreeNode pAugmentedMergeTreeNode = (PAugmentedMergeTreeNode)hashMap.get(cPSTransfer.id);
                if (pAugmentedMergeTreeNode == null) {
                    pAugmentedMergeTreeNode = this.createTreeNode(cPSTransfer.id);
                    hashMap.put(cPSTransfer.id, pAugmentedMergeTreeNode);
                }
                for (n3 = 0; n3 < 8; ++n3) {
                    if (cPSTransfer.setID[n3] < 0) continue;
                    PAugmentedMergeTreeNode pAugmentedMergeTreeNode2 = (PAugmentedMergeTreeNode)hashMap.get(cPSTransfer.setID[n3]);
                    if (pAugmentedMergeTreeNode2 == null) {
                        pAugmentedMergeTreeNode2 = this.createTreeNode(cPSTransfer.setID[n3]);
                        hashMap.put(cPSTransfer.setID[n3], pAugmentedMergeTreeNode2);
                    }
                    pAugmentedMergeTreeNode.addChild(pAugmentedMergeTreeNode2);
                }
                this.head = (AbstractMergeTreeNode)hashMap.get(cPSTransfer.id);
                continue;
            }
            if (cPSTransfer.ref < 2) continue;
            int n4 = 0;
            for (n3 = 0; n3 < 8; ++n3) {
                if (cPSTransfer.setID[n3] < 0) continue;
                cPSTransfer.setID[n3] = arrayDisjointSet.find(cPSTransfer.setID[n3]);
                for (int j = 0; j < n3; ++j) {
                    if (cPSTransfer.setID[j] != cPSTransfer.setID[n3]) continue;
                    cPSTransfer.setID[n3] = -1;
                }
                if (cPSTransfer.setID[n3] == -1) continue;
                cPSTransfer.setID[n4++] = cPSTransfer.setID[n3];
            }
            if (n4 < 2) continue;
            for (n3 = 0; n3 < n4; ++n3) {
                arrayDisjointSet.union(cPSTransfer.id, cPSTransfer.setID[n3]);
            }
            if (!hashMap.containsKey(cPSTransfer.id)) {
                hashMap.put(cPSTransfer.id, this.createTreeNode(cPSTransfer.id));
            }
            for (n3 = 0; n3 < n4; ++n3) {
                if (!hashMap.containsKey(cPSTransfer.setID[n3])) {
                    hashMap.put(cPSTransfer.setID[n3], this.createTreeNode(cPSTransfer.setID[n3]));
                }
                ((PAugmentedMergeTreeNode)hashMap.get(cPSTransfer.id)).addChild((AbstractMergeTreeNode)hashMap.get(cPSTransfer.setID[n3]));
            }
            this.head = (AbstractMergeTreeNode)hashMap.get(cPSTransfer.id);
        }
        this.total = hashMap.size();
    }

    protected abstract PAugmentedMergeTreeNode createTreeNode(int var1);

    class HashDJSRecord {
        int key;
        int value;
        float data;
        int next;

        HashDJSRecord(PAugmentedMergeTree pAugmentedMergeTree) {
            Objects.requireNonNull(pAugmentedMergeTree);
        }
    }

    private static class CPSTransfer {
        int read = 0;
        int id;
        float val;
        int ref;
        int[] setID = new int[8];

        private CPSTransfer() {
        }

        static int size() {
            return 11;
        }

        public boolean loadNext(ByteBuffer byteBuffer) {
            ++this.read;
            this.id = byteBuffer.getInt();
            this.val = byteBuffer.getFloat();
            this.ref = byteBuffer.getInt();
            for (int i = 0; i < 8; ++i) {
                this.setID[i] = byteBuffer.getInt();
            }
            return true;
        }

        public void print(PrintStream printStream) {
            printStream.print("[" + this.read + "] " + this.id + " (value: " + this.val + ") (ref: " + this.ref + ") -- ");
            for (int i = 0; i < 8; ++i) {
                printStream.print(this.setID[i] + ", ");
            }
            printStream.println();
        }
    }

    class HashRecord {
        int value;
        int data;
        int next;

        HashRecord(PAugmentedMergeTree pAugmentedMergeTree) {
            Objects.requireNonNull(pAugmentedMergeTree);
        }
    }

    public abstract class PAugmentedMergeTreeNode
    extends AbstractMergeTreeNode
    implements TopoTreeNode {
        int idx;
        final /* synthetic */ PAugmentedMergeTree this$0;

        protected PAugmentedMergeTreeNode(PAugmentedMergeTree pAugmentedMergeTree, Integer n) {
            PAugmentedMergeTree pAugmentedMergeTree2 = pAugmentedMergeTree;
            Objects.requireNonNull(pAugmentedMergeTree2);
            this.this$0 = pAugmentedMergeTree2;
            super(n);
            this.idx = n;
        }

        protected PAugmentedMergeTreeNode(PAugmentedMergeTree pAugmentedMergeTree, int n, int n2) {
            PAugmentedMergeTree pAugmentedMergeTree2 = pAugmentedMergeTree;
            Objects.requireNonNull(pAugmentedMergeTree2);
            this.this$0 = pAugmentedMergeTree2;
            super(new Integer(n2 * pAugmentedMergeTree.sf.getWidth() + n));
            this.idx = n2 * pAugmentedMergeTree.sf.getWidth() + n;
        }

        @Override
        public float getValue() {
            return this.this$0.sf.getValue(this.idx);
        }

        @Override
        public void addChild(AbstractMergeTreeNode abstractMergeTreeNode) {
            if (this.children.size() < 2) {
                super.addChild(abstractMergeTreeNode);
            } else {
                AbstractMergeTreeNode abstractMergeTreeNode2 = (AbstractMergeTreeNode)this.children.get(1);
                this.children.remove(1);
                PAugmentedMergeTreeNode pAugmentedMergeTreeNode = this.this$0.createTreeNode(this.idx);
                this.children.add(pAugmentedMergeTreeNode);
                pAugmentedMergeTreeNode.addChild(abstractMergeTreeNode);
                pAugmentedMergeTreeNode.addChild(abstractMergeTreeNode2);
            }
        }
    }
}

