% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipse.R
\name{ellipse}
\alias{ellipse}
\title{Add an ellipse in an existing plot}
\usage{
ellipse(
  x0 = 0,
  y0 = 0,
  a = 1,
  b = 2,
  alpha = 0,
  length = 1000,
  col = NULL,
  fill = NA,
  border,
  ...
)
}
\arguments{
\item{x0}{x-coordinate of the ellipse center}

\item{y0}{y-coordinate of the ellipse center}

\item{a}{Length of semi-major axis}

\item{b}{Length of semi-minor axis}

\item{alpha}{Rotation of the ellipse with regard to the X-axis in radian}

\item{length}{How many points are generated to simulate the ellipse}

\item{col}{Ellipse border color}

\item{fill}{Ellipse fill color}

\item{border}{Equivalent to \code{col}}

\item{...}{further parameters passed to \code{\link{polygon}}}
}
\value{
Invisible coordinates of points on the ellipse
}
\description{
Add an ellipse in an existing plot
}
\examples{


if(interactive()) {
  plot.new()
  plot.window(xlim=c(-1, 1), ylim=c(-1,1))
  ellipseCols <- heat.colors(11)
  ellipse(0, 0, a=1, b=0.5, alpha=0)
  for(i in 1:11) {
    ellipse(0, 0, a=1, b=0.5, alpha=degree2radian(i*15), col=ellipseCols[i])
  }
  ellipse(0, 0, a=1, b=1, col="black", lwd=2)
  ellipse(0, 0, a=0.5, b=0.5, fill="steelblue")
}

}
