% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figurePanel.R
\name{figurePanel}
\alias{figurePanel}
\title{Make a figure panel with title}
\usage{
figurePanel(gg, title)
}
\arguments{
\item{gg}{A \code{grob} object}

\item{title}{Character, title of the plot panel, e.g. \code{A}, \code{(B)},
etc.}
}
\value{
A \code{grob} object
}
\description{
Make a figure panel with title
}
\examples{

require("ggplot2")
df <- data.frame(
  gp = factor(rep(letters[1:3], each = 10)),
  y = rnorm(30)
)

ds <- do.call(rbind, lapply(split(df, df$gp), function(d) {
  data.frame(mean = mean(d$y), sd = sd(d$y), gp = d$gp)
  }))
  
g1 <- ggplot(df, aes(gp, y)) +
  geom_point() +
  geom_point(data = ds, aes(y = mean), colour = 'red', size = 3)
  
g2 <- ggplot() +
  geom_point(data = df, aes(gp, y)) +
  geom_point(data = ds, aes(gp, mean), colour = 'red', size = 3) +
  geom_errorbar(
    data = ds,
    aes(gp, mean, ymin = mean - sd, ymax = mean + sd),
    colour = 'red',
    width = 0.4
  )
  
panelA <- figurePanel(g1, "(A)")
panelB <- figurePanel(g2, "(B)")
layoutMat <- matrix(c(1,2), nrow=1)
gridExtra::grid.arrange(grobs=list(panelA, panelB),
 layout_matrix=layoutMat)

}
