% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getLims}
\alias{getLims}
\title{Get xlim/ylim ranges for plots from real values}
\usage{
getLims(..., perc = 0.99, symm = TRUE)
}
\arguments{
\item{...}{one or more vectors of real values}

\item{perc}{percentage of dynamic range that should be covered by the
limits; if set to 1 the whole range is used.}

\item{symm}{logical value; if set to \code{TRUE}, the range will be
symmetric around zero}
}
\value{
A numeric vector of length 2 giving the lower and upper axis limits.
}
\description{
Get xlim/ylim ranges for plots from real values
}
\examples{

myX <- rnorm(100, mean=1)
myY <- rnorm(100)
myLim <- getLims(myX, myY, perc=0.99)
plot(myX, myY, xlim=myLim, ylim=myLim)
mySymmLim <- getLims(myX, myY, perc=0.99, symm=TRUE)
plot(myX, myY, xlim=myLim, ylim=mySymmLim)


}
