% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVenn.R
\name{plotVenn}
\alias{plotVenn}
\title{Plot Venn object of the Vennerable package}
\usage{
plotVenn(
  venn,
  main = "",
  show = list(FaceText = "weight", Universe = FALSE),
  ...
)
}
\arguments{
\item{venn}{Venn object from the Vennerable package}

\item{main}{Figure title}

\item{show}{Named list controlling which elements to display.
Supported elements: \code{Universe} (logical), \code{Sets} (logical),
\code{SetLabels} (logical), \code{DarkMatter} (logical),
\code{Faces} (logical), \code{FaceText} (character, e.g. \code{"weight"}).}

\item{...}{Other parameters passed to \code{Vennerable::compute.Venn}}
}
\value{
Side effect is used - a plot is generated.
}
\description{
The function plots Venn objects from the Vennerable package with
custom margins that better suit publication figures.
}
\note{
The function requires Vennerable package version 3.0 or later.
  Plotting logic adapted from Vennerable (GPL license).
}
\examples{

if (requireNamespace("Vennerable", quietly = TRUE)) {
  myVenn <- list(A = LETTERS[1:24], B = LETTERS[3:8], C = LETTERS[5:9])
  plotVenn(Vennerable::Venn(myVenn), main = "Letters")
}

}
