% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vennMembers.R
\name{vennMembersDataframe}
\alias{vennMembersDataframe}
\title{Extract members of each region in Venn diagrams in to a data.frame}
\usage{
vennMembersDataframe(venn)
}
\arguments{
\item{venn}{A Venn object}
}
\value{
A data.frame containing logical values of sets and elements
}
\description{
Extract members of each region in Venn diagrams in to a data.frame
}
\examples{
if(requireNamespace("Vennerable")) {
  myList <- list(A=LETTERS[1:5], B=LETTERS[2:7], C=LETTERS[seq(2,9,2)])
  myVenn <- Vennerable::Venn(myList)
  myVennDf <- vennMembersDataframe(myVenn)
  print(myVennDf)
}
}
