% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxp_chronicler.R
\name{rxp_check_chronicles}
\alias{rxp_check_chronicles}
\title{Check Pipeline Outputs for Chronicle Status}
\usage{
rxp_check_chronicles(project_path = ".", which_log = NULL)
}
\arguments{
\item{project_path}{Character, defaults to ".".
Path to the root directory of the project.}

\item{which_log}{Character, defaults to NULL. If NULL the most recent
build log is used. If a string is provided, it's used as a
regular expression to match against available log files.}
}
\value{
A data frame with columns: derivation, chronicle_state,
num_operations, num_failed, failed_functions, messages.
Returns NULL invisibly if chronicler is not installed or no
chronicle objects are found.
}
\description{
Scans all derivation outputs for chronicle objects and
reports their status: success (Just, no warnings), warning (Just with
warnings), or nothing (failed computation). Only active when chronicler
is installed.
}
\details{
This function is useful when using the \code{{chronicler}} package in your
rixpress pipeline. Because chronicler catches errors and warnings,
returning \code{Nothing} values instead of failing, Nix builds will always
succeed. This function helps identify derivations that contain failed
computations.

The function displays one of three symbols for each chronicle:
\itemize{
\item \code{checkmark} Success: Just value, no warnings or errors
\item \code{warning sign} Warning: Just value, but warnings were captured
\item \code{X mark} Nothing: Failed computation, errors captured
}
}
\examples{
\dontrun{
  # After building a pipeline with chronicler functions
  rxp_check_chronicles()

  # Check a specific build log
  rxp_check_chronicles(which_log = "20250131")
}
}
\seealso{
Other utilities: 
\code{\link{print.rxp_derivation}()},
\code{\link{rxp_copy}()},
\code{\link{rxp_gc}()},
\code{\link{rxp_init}()},
\code{\link{rxp_inspect}()},
\code{\link{rxp_list_logs}()},
\code{\link{rxp_load}()},
\code{\link{rxp_read}()},
\code{\link{rxp_trace}()}
}
\concept{utilities}
