/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.eco.EcoException;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.stats.likelihood.InternalConcentratedLikelihood;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;

public interface ConcentratedLikelihood
extends Likelihood {
    public static Builder builder() {
        return new Builder();
    }

    public DoubleSeq coefficients();

    public double coefficient(int var1);

    public FastMatrix unscaledCovariance();

    default public FastMatrix covariance(int nhp, boolean unbiased) {
        if (this.nx() == 0) {
            return FastMatrix.EMPTY;
        }
        FastMatrix v = this.unscaledCovariance().deepClone();
        int ndf = unbiased ? this.dim() - this.nx() - nhp : this.dim();
        double sig2 = this.ssq() / (double)ndf;
        v.mul(sig2);
        return v;
    }

    default public int nx() {
        return this.coefficients().length();
    }

    default public int degreesOfFreedom() {
        return this.dim() - this.nx();
    }

    default public double ser(int ix, int nhp, boolean unbiased) {
        double e = this.unscaledCovariance().get(ix, ix);
        if (e == 0.0) {
            return Double.NaN;
        }
        double b = this.coefficients().get(ix);
        if (b == 0.0) {
            return 0.0;
        }
        int ndf = unbiased ? this.dim() - this.nx() - nhp : this.dim();
        return Math.sqrt(e * this.ssq() / (double)ndf);
    }

    default public double[] ser(int nhp, boolean unbiased) {
        if (this.nx() == 0) {
            return DoubleSeq.EMPTYARRAY;
        }
        double[] e = this.unscaledCovariance().diagonal().toArray();
        int ndf = unbiased ? this.dim() - this.nx() - nhp : this.dim();
        double ssq = this.ssq();
        for (int i = 0; i < e.length; ++i) {
            e[i] = Math.sqrt(e[i] * ssq / (double)ndf);
        }
        return e;
    }

    default public double tstat(int ix, int nhp, boolean unbiased) {
        if (!this.isScalingFactor()) {
            throw new EcoException("Unexpected operation");
        }
        return this.coefficient(ix) / this.ser(ix, nhp, unbiased);
    }

    default public double[] tstats(int nhp, boolean unbiased) {
        if (!this.isScalingFactor()) {
            throw new EcoException("Unexpected operation");
        }
        double[] t = this.ser(nhp, unbiased);
        DoubleSeqCursor reader = this.coefficients().cursor();
        for (int i = 0; i < t.length; ++i) {
            t[i] = reader.getAndNext() / t[i];
        }
        return t;
    }

    public static class Builder {
        private static final double[] B_EMPTY = new double[0];
        private int n;
        private double ssqerr;
        private double ldet;
        private double[] res;
        private double[] b = B_EMPTY;
        private FastMatrix bvar;
        private boolean scalingFactor = true;

        private Builder() {
        }

        public Builder ndata(int n) {
            this.n = n;
            return this;
        }

        public Builder scalingFactor(boolean scalingFactor) {
            this.scalingFactor = scalingFactor;
            return this;
        }

        public Builder logDeterminant(double ldet) {
            this.ldet = ldet;
            return this;
        }

        public Builder ssqErr(double ssq) {
            this.ssqerr = ssq;
            return this;
        }

        public Builder residuals(DoubleSeq residuals) {
            if (residuals == null) {
                return this;
            }
            if (this.ssqerr == 0.0) {
                this.ssqerr = residuals.ssq();
            }
            this.res = residuals.toArray();
            return this;
        }

        public Builder coefficients(DoubleSeq coeff) {
            if (coeff != null) {
                this.b = coeff.toArray();
            }
            return this;
        }

        public Builder unscaledCovariance(FastMatrix var) {
            this.bvar = var;
            return this;
        }

        public ConcentratedLikelihood build() {
            return new InternalConcentratedLikelihood(this.n, this.ssqerr, this.ldet, this.res, this.b, this.bvar, this.scalingFactor);
        }
    }
}

