% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bobyqa_rosen_test2}
\alias{bobyqa_rosen_test2}
\title{Example 0b: Minimize Rosenbrock function using bobyqa}
\usage{
bobyqa_rosen_test2(start, lower, upper)
}
\arguments{
\item{start}{Starting values of the algorithm.}

\item{lower}{Lower bounds of the parameters.}

\item{upper}{Upper bounds of the parameters.}
}
\value{
No return value, called for side effects.
}
\description{
Minimize Rosenbrock function using bobyqa and
            expect a normal exit from bobyqa. Allows for user input.
}
\examples{
fr <- function(x) {   ## Rosenbrock Banana function
 x1 <- x[1]
 x2 <- x[2]
 100 * (x2 - x1 * x1)^2 + (1 - x1)^2
}
(x1 <- minqa::bobyqa(c(1, 2), fr, lower = c(0, 0), upper = c(4, 4)))
## => optimum at c(1, 1) with fval = 0
str(x1) # see that the error code and msg are returned

## corresponding C++ implementation:
bobyqa_rosen_test2(c(1,2),c(0,0),c(4,4))
}
