% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tasks.R
\name{add_tasks_in_project}
\alias{add_tasks_in_project}
\title{Add tasks in project}
\usage{
add_tasks_in_project(
  project_id = get_project_id(project_name = project_name, token = token),
  tasks,
  project_name,
  verbose = FALSE,
  responsible = NULL,
  due = NULL,
  section_name = NULL,
  token = get_todoist_api_token(),
  all_users = get_all_users(token = token),
  update_only = FALSE,
  check_only = FALSE,
  que_si_necessaire = TRUE
)
}
\arguments{
\item{project_id}{id of the project}

\item{tasks}{tasks to add, as character vector}

\item{project_name}{name of the project}

\item{verbose}{boolean that make the function verbose}

\item{responsible}{add people in project}

\item{due}{due date}

\item{section_name}{section name}

\item{token}{todoist API token}

\item{all_users}{all_users}

\item{update_only}{boolean if true, only update existing (not closed) todo}

\item{check_only}{check_only}

\item{que_si_necessaire}{que_si_necessaire}
}
\value{
id of project (character vector)
}
\description{
Add tasks in project
}
\examples{
\dontrun{
add_project("my_proj") \%>\%
   add_tasks_in_project(c("First task", "Second task"))
}
}
