% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_post.R
\name{plot.trim.totals}
\alias{plot.trim.totals}
\title{Plot time-totals from trim output.}
\usage{
\method{plot}{trim.totals}(
  x,
  ...,
  names = NULL,
  xlab = "auto",
  ylab = "Time totals",
  leg.pos = "topleft",
  band = "se"
)
}
\arguments{
\item{x}{an object of class \code{trim.totals}, as resulting from e.g. a call to \code{totals}.}

\item{...}{optional additional \code{trim.totals} objects.}

\item{names}{optional character vector with names for the various series.}

\item{xlab}{x-axis label. The default value of "auto" will be changed into "Year" or "Time Point", whichever is more appropriate.}

\item{ylab}{y-axis label.}

\item{leg.pos}{legend position, similar as in \code{\link[graphics]{legend}}.}

\item{band}{Defines if the uncertainty band will be plotted using standard errors ("se") or confidence intervals ("ci").}
}
\description{
This function plots a time series of one or more \code{trim.totals} objects, i.e. the output of \code{totals}.
Both the time totals themselves, as the associated standard errros will be plotted,
the former as a solid line with markers, the latter as a transparent band.
}
\details{
Additionally, the observed counts will be plotted (as a line) when this was asked for in the call to \code{totals}.

Multiple time-total data sets can be compared in a single plot
}
\examples{

# Simple example
data(skylark2)
z <- trim(count ~ site + year, data=skylark2, model=3)
plot(totals(z))

# Extended example
z1 <- trim(count ~ site + year + habitat, data=skylark2, model=3)
z2 <- trim(count ~ site + year, data=skylark2, model=3)
t1 <- totals(z1, obs=TRUE)
t2 <- totals(z2, obs=TRUE)
plot(t1, t2, names=c("with covariates", "without covariates"), main="Skylark", leg.pos="bottom")

}
\seealso{
Other graphical post-processing: 
\code{\link{heatmap}()},
\code{\link{plot.trim.index}()}
}
\concept{graphical post-processing}
