% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_with_vg.R
\name{dml}
\alias{dml}
\title{Wrap plot instructions for DrawingML plotting in Powerpoint}
\usage{
dml(
  code,
  ggobj = NULL,
  bg = "white",
  fonts = list(),
  pointsize = 12,
  editable = TRUE,
  ...
)
}
\arguments{
\item{code}{plotting instructions}

\item{ggobj}{ggplot object to print. argument code will be ignored if this
argument is supplied.}

\item{bg, fonts, pointsize, editable}{Parameters stored and
later passed to \code{\link{dml_pptx}} by \code{\link{ph_with.dml}}.}

\item{...}{unused arguments}
}
\description{
A simple wrapper to mark
the plot instructions as Vector Graphics instructions. It produces
an object of class 'dml' with a corresponding method \code{\link[officer]{ph_with}}.

The function enables usage of any R plot with argument \code{code} and with
ggplot objects with argument \code{ggobj}.

\strong{Note:} the output is a vector graphic, not a native Microsoft Office
chart. The underlying data is not embedded in the document.
}
\section{background color}{

When dealing with a ggplot object, the \code{bg} parameter sets the
device background but the ggplot theme's \code{plot.background} will
typically draw over it. To control the background appearance,
set it in the theme instead:

\if{html}{\out{<div class="sourceCode">}}\preformatted{theme(
  panel.background = element_rect(fill = "#EFEFEF"),
  plot.background = element_rect(fill = "wheat"))
}\if{html}{\out{</div>}}
}

\section{Limitations}{

The DrawingML format does not support the following R graphics features:
\itemize{
\item \strong{Patterns and gradients}: grid patterns (\code{GridPattern}),
linear and radial gradients used as fill are not translated into
DrawingML. ggplot2 will emit a warning when these are used.
\item \strong{Rich text (ggtext/gridtext)}: packages such as \code{ggtext} render
HTML/Markdown into composite grid grobs. The rvg device can only
capture low-level primitives (text strings, lines, polygons), so
the rich formatting (inline images, coloured spans, HTML markup)
is lost. Use standard ggplot2 text functions or apply formatting
after export in PowerPoint.
\item \strong{Plotmath expressions}: R's graphics engine decomposes
\code{expression()} into individual text primitives before the device
sees them. Compound expressions (e.g. \code{expression("a" * "b")},
superscripts, subscripts) are rendered as separate text boxes,
causing vertical misalignment.
\item \strong{Clipping paths, masks, compositing and transformations}:
these R >= 4.1 features have no DrawingML equivalent and are
silently ignored.
}
}

\examples{
anyplot <- dml(code = barplot(1:5, col = 2:6), bg = "wheat")

library(officer)
doc <- read_pptx()
doc <- add_slide(doc, "Title and Content", "Office Theme")
doc <- ph_with(doc, anyplot, location = ph_location_fullsize())
fileout <- tempfile(fileext = ".pptx")
# fileout <- "vg.pptx"
print(doc, target = fileout)
}
\seealso{
\code{\link{ph_with.dml}}
}
