% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-remove.R
\name{sas_file_remove}
\alias{sas_file_remove}
\title{Delete a file or directory from SAS}
\usage{
sas_file_remove(path)
}
\arguments{
\item{path}{string; Path of file on remote SAS server to be deleted.}
}
\value{
\code{logical}; value indicating if the operation succeeded.
}
\description{
Deletes a file or directory from the remote SAS server. Is analogous to
\code{file.remove()}, but for the remote SAS server.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# connect to SAS
sas_connect()

# create an example file
local_path <- tempfile(fileext = ".txt")
cat("some example text", file = tempfile_path)

sas_path <- readline(
  "Please provide the full path to upload an example file to (e.g., ~/example.txt)."
)
sas_file_upload(local_path, sas_path)

sas_file_remove(sas_path)

# cleanup
unlink(local_path)
\dontshow{\}) # examplesIf}
}
\seealso{
Other file management functions: 
\code{\link{sas_file_copy}()},
\code{\link{sas_file_download}()},
\code{\link{sas_file_exists}()},
\code{\link{sas_file_upload}()},
\code{\link{sas_list}()}
}
\concept{file management functions}
