% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file-upload.R
\name{sas_file_upload}
\alias{sas_file_upload}
\title{Upload a file to SAS}
\usage{
sas_file_upload(local_path, sas_path)
}
\arguments{
\item{local_path}{string; Path of file on local machine to be uploaded.}

\item{sas_path}{string; Path to upload local file to on the remote SAS server.}
}
\value{
\code{logical}; value indicating if the operation succeeded.
}
\description{
Uploads a file to the remote SAS server.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# connect to SAS
sas_connect()

# create an example file
local_path <- tempfile(fileext = ".txt")
cat("some example text", file = tempfile_path)

sas_path <- readline(
  "Please provide the full path to upload an example file to (e.g., ~/example.txt)."
)
sas_file_upload(local_path, sas_path)

# cleanup
unlink(local_path)
sas_file_remove(sas_path)
\dontshow{\}) # examplesIf}
}
\seealso{
Other file management functions: 
\code{\link{sas_file_copy}()},
\code{\link{sas_file_download}()},
\code{\link{sas_file_exists}()},
\code{\link{sas_file_remove}()},
\code{\link{sas_list}()}
}
\concept{file management functions}
