% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run-file.R
\name{sas_run_file}
\alias{sas_run_file}
\title{Execute SAS file}
\usage{
sas_run_file(input_path, output_path, overwrite = FALSE)
}
\arguments{
\item{input_path}{string; Path of SAS file to run.}

\item{output_path}{optional string; Path to save html output to (log file will be
named the same).}

\item{overwrite}{logical; Can output overwrite prior output?}
}
\value{
If \code{output_path} specified, \code{htmlwidget}. Else, no return value.
}
\description{
Execute a SAS file and render html output or save output as html and log.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
sas_connect()

tempfile_sas_path <- tempfile(fileext = ".sas")
tempfile_html_path <- sub("\\\\.sas$", ".html", tempfile_sas_path)
tempfile_log_path <- sub("\\\\.sas$", ".log", tempfile_sas_path)
cat("PROC MEANS DATA = sashelp.cars;RUN;", file = tempfile_sas_path)
sas_run_file(tempfile_sas_path, tempfile_html_path)

# clean up
unlink(tempfile_sas_path)
unlink(tempfile_html_path)
unlink(tempfile_log_path)
\dontshow{\}) # examplesIf}
}
\seealso{
Other code execution functions: 
\code{\link{sas_run_selected}()},
\code{\link{sas_run_string}()}
}
\concept{code execution functions}
