% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_info.R
\name{tif}
\alias{tif}
\title{Test Information Function (TIF)}
\usage{
tif(iifs, fun = "sum", theta = seq(-5, 5, length.out = 1000))
}
\arguments{
\item{iifs}{object of class \code{iifs} containg the item information functions}

\item{fun}{\code{character}, defines the function for the computation of the TIF, either by summing the items (sum) or by computing the mean (mean)}

\item{theta}{\code{numeric} latent trait level of person \eqn{p}, it can be a single value or a vector of values. Default is a vector of 1 thousand values ranging from -5 to +5}
}
\value{
A \code{data.frame} of class \code{tif} with two columns: (i) \code{theta} containing the latent trait values, and (ii) \code{tif} containing the TIF values computed as either the sum or the mean of the IIFs
}
\description{
Compute the test information function of a test given a matrix of item information functions
}
\examples{
set.seed(123)
n <- 5
item_par <- data.frame(
  b = runif(n, -3, 3),
  a = runif(n, 1.2, 1.9),
  c = rep(0, n),
  e = rep(1, n)
)
iifs <- item_info(item_par)
test_tif <- tif(iifs)
}
