% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic.R
\name{ic}
\alias{ic}
\alias{ic,sf-method}
\alias{ic,SpatRaster-method}
\title{optimal parameter search for intersectional cardinality}
\usage{
\S4method{ic}{sf}(
  data,
  column,
  target,
  E = 2:10,
  k = E + 2,
  tau = 1,
  style = 1,
  lib = NULL,
  pred = NULL,
  dist.metric = "L2",
  threads = detectThreads(),
  detrend = FALSE,
  nb = NULL
)

\S4method{ic}{SpatRaster}(
  data,
  column,
  target,
  E = 2:10,
  k = E + 2,
  tau = 1,
  style = 1,
  lib = NULL,
  pred = NULL,
  dist.metric = "L2",
  threads = detectThreads(),
  detrend = FALSE,
  grid.coord = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{column}{name of library variable.}

\item{target}{name of target variable.}

\item{E}{(optional) embedding dimensions.}

\item{k}{(optional) number of nearest neighbors used.}

\item{tau}{(optional) step of spatial lags.}

\item{style}{(optional) embedding style (\code{0} includes current state, \code{1} excludes it).}

\item{lib}{(optional) libraries indices (input needed: \code{vector} - spatial vector, \code{matrix} - spatial raster).}

\item{pred}{(optional) predictions indices (input requirement same as \code{lib}).}

\item{dist.metric}{(optional) distance metric (\code{L1}: Manhattan, \code{L2}: Euclidean).}

\item{threads}{(optional) number of threads to use.}

\item{detrend}{(optional) whether to remove the linear trend.}

\item{nb}{(optional) neighbours list.}

\item{grid.coord}{(optional) whether to detrend using cell center coordinates (\code{TRUE}) or row/column numbers (\code{FALSE}).}
}
\value{
A list
\describe{
\item{\code{xmap}}{cross mapping performance}
\item{\code{varname}}{name of target variable}
\item{\code{method}}{method of cross mapping}
}
}
\description{
optimal parameter search for intersectional cardinality
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg",package="spEDM"))
\donttest{
ic(columbus,"hoval","crime",E = 7,k = 15:25)
}
}
\references{
Tao, P., Wang, Q., Shi, J., Hao, X., Liu, X., Min, B., Zhang, Y., Li, C., Cui, H., Chen, L., 2023. Detecting dynamical causality by intersection cardinal concavity. Fundamental Research.
}
