% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_rotation_gif}
\alias{create_rotation_gif}
\title{Create animated GIF of rotating 3D point cloud}
\usage{
create_rotation_gif(
  las,
  output_path = "pointcloud_rotation.gif",
  duration = 12,
  rpm = 5,
  background = "white",
  axis = "z",
  show_axis = TRUE,
  show_legend = TRUE,
  screen_size = c(800, 600),
  overwrite = FALSE
)
}
\arguments{
\item{las}{LAS object to visualize. Should have R, G, B fields for color.}

\item{output_path}{Character string specifying output GIF file path.
Default is "pointcloud_rotation.gif".}

\item{duration}{Numeric duration of the animation in seconds. Default is 12.}

\item{rpm}{Numeric rotations per minute for the spin. Default is 5.}

\item{background}{Character string specifying background color. Default is "white".}

\item{axis}{Character specifying rotation axis: "z" for vertical rotation (default),
"x" for horizontal rotation, "y" for front-to-back rotation.}

\item{show_axis}{Logical whether to show axes. Default is TRUE.}

\item{show_legend}{Logical whether to show legend. Default is TRUE.}

\item{screen_size}{Numeric vector of length 2 specifying window dimensions as c(width, height).
Default is c(800, 600).}

\item{overwrite}{Logical whether to overwrite existing output file. Default is FALSE.}
}
\value{
Character string of the output file path (invisible)
}
\description{
Generates a 360-degree rotating animation of a LAS point cloud using rgl
and saves it as an animated GIF.
}
\details{
This function creates a smooth 360-degree rotation animation by:
\itemize{
\item Plotting the point cloud using lidR's plot function with RGB colors
\item Using rgl's movie3d and spin3d to create smooth rotation
\item Saving the result as an animated GIF
}

The rotation speed is controlled by the rpm (rotations per minute) parameter.
The total duration determines how long the animation will be.

Requires the \code{rgl} package and lidR for plotting.
}
\examples{
\donttest{
# Load example LAS file
LASfile <- system.file("extdata", "ALS_Clip.laz", package="spanner")
las <- readLAS(LASfile)

# Create basic rotation GIF with attribute coloring
las_colored <- colorize_las(las, method="attr", attribute_name="Z")
create_rotation_gif(las_colored, output_path=tempfile(fileext = ".gif"))

# High quality with specific settings
create_rotation_gif(las_colored,
                    output_path=tempfile(fileext = ".gif"),
                    duration=15,
                    rpm=10,
                    background="black",
                    show_axis=FALSE,
                    show_legend=FALSE)

# Rotate around X axis for side-to-side view
create_rotation_gif(las_colored, output_path=tempfile(fileext = ".gif"), axis="x")
}

}
