% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Patch_Morph.R
\name{sum_rasters_by_suitability}
\alias{sum_rasters_by_suitability}
\title{Sum rasters by suitability level}
\usage{
sum_rasters_by_suitability(rasters, suitList)
}
\arguments{
\item{rasters}{list A list of rasters.}

\item{suitList}{numeric A vector of suitability levels.}
}
\value{
list A list of summed rasters for each suitability level.
}
\description{
\code{sum_rasters_by_suitability} sums rasters from a list based on their suitability levels.
}
\examples{
\donttest{
# Define input parameters
las <- lidR::readLAS(system.file("extdata", "MixedConifer.laz", package="lidR"))
input_raster <- lidR::rasterize_canopy(las, res = 1, lidR::pitfree(c(0,2,5,10,15), c(0, 2)))
suitList <- c(0, 2, 32)
gapList <- seq(1, 8, by = 1)
spurList <- seq(1, 8, by = 1)

# Process the rasters
processed_rasters <- process_rasters_patchmorph(input_raster, suitList, gapList, spurList)

# Sum rasters by suitability level
summed_rasters <- sum_rasters_by_suitability(processed_rasters, suitList)

# Call the plot_raster_by_name function to plot the raster named "suit_2_sum"
plot_raster_by_name(summed_rasters, "suit_2_sum")
}

}
