% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.ci.prop2}
\alias{size.ci.prop2}
\title{Sample size for a 2-group proportion difference confidence interval}
\usage{
size.ci.prop2(alpha, p1, p2, w, R)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{p1}{planning value of proportion for group 1}

\item{p2}{planning value of proportion for group 2}

\item{w}{desired confidence interval width}

\item{R}{n2/n1 ratio}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group required to estimate a difference
of proportions with desired confidence interval precision in a 2-group
design. Set the proportion planning values to .5 for a conservatively
large sample size. Set R = 1 for equal sample sizes.

For more details, see Section 2.22 of Bonett (2021, Volume 3)
}
\examples{
size.ci.prop2(.05, .05, .15, .1, 1)

# Should return:
#   n1  n2
#  269 269

size.ci.prop2(.05, .4, .2, .15, .5)

# Should return:
#   n1  n2
#  383 192


}
\references{
\insertRef{Bonett2021}{statpsych}
}
