% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stddiff_spark.R
\name{stddiff.binary}
\alias{stddiff.binary}
\title{Compute Standardized Differences for Binary Variables (Spark)}
\usage{
stddiff.binary(data, gcol, vcol, verbose = FALSE)
}
\arguments{
\item{data}{A Spark DataFrame (\code{tbl_spark}) containing the variables.}

\item{gcol}{Integer; column index of the binary grouping variable
(e.g., treatment vs control).}

\item{vcol}{Integer vector; column indices of the binary variables to analyze.}

\item{verbose}{Logical; if TRUE, prints progress messages. Default is FALSE.}
}
\value{
A numeric matrix with one row per variable and columns:
\itemize{
\item \code{p.c}: Proportion in control group (first level alphabetically)
\item \code{p.t}: Proportion in treatment group (second level alphabetically)
\item \code{missing.c}: Number of missing values in control group
\item \code{missing.t}: Number of missing values in treatment group
\item \code{stddiff}: Standardized difference
\item \code{stddiff.l}: Lower bound of 95\% confidence interval
\item \code{stddiff.u}: Upper bound of 95\% confidence interval
}
}
\description{
Calculates standardized differences for binary variables using a Spark
DataFrame. Equivalent to \code{stddiff::stddiff.binary} but operates on Spark data.
}
\details{
Variables are encoded using lexicographic ordering since Spark does not
have factor types. The first level alphabetically becomes 0, the second
becomes 1.

The standardized difference is computed as:
\deqn{d = \frac{|p_t - p_c|}{\sqrt{(p_t(1-p_t) + p_c(1-p_c))/2}}}
}
\examples{
\dontshow{if (requireNamespace("sparklyr", quietly = TRUE) && interactive()) withAutoprint(\{ # examplesIf}
sc <- sparklyr::spark_connect(master = "local")

spark_df <- sparklyr::copy_to(sc, mtcars)

result <- stddiff.binary(
  data = spark_df,
  gcol = 9,   # column index of grouping variable
  vcol = c(8) # columns of binary variables
)

sparklyr::spark_disconnect(sc)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{stddiff.category}}, \code{\link{stddiff.numeric}}
}
