% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{createOutcome}
\alias{createOutcome}
\title{Create Outcome Object}
\usage{
createOutcome(outcome)
}
\arguments{
\item{outcome}{Vector of outcome values}
}
\value{
\code{Outcome} object
}
\description{
Create an outcome object

This function is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai
}
\examples{
X <- matrix(runif(10*100), ncol = 10)
y <- -5 + 10*(X[,1] > 0.5) + rnorm(100)
outcome <- createOutcome(y)
}
