% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_qsm.R
\name{branch_volume_weighted_stats}
\alias{branch_volume_weighted_stats}
\title{Calculate volume weighted branch statistics}
\usage{
branch_volume_weighted_stats(qsm, breaks = NULL, FUN = function(x) mean(x))
}
\arguments{
\item{qsm}{a QSM loaded using `[load_qsm()]`.}

\item{breaks}{numeric -- a vector of diameter classes (in cm) by which to
summarize branch volume. If `NULL` the branch of branch sizes will be
distributed across 1 cm bins.}

\item{FUN}{function -- central tendency function to be weighted based on
branch volume.}
}
\value{
A numeric value representing the volume-weighted statistic
calculated by `FUN` across branch diameter classes.
}
\description{
This function calculates statistics on branch diameters weighted by the
volume of branches of that size based on outputs from
 `branch_size_distribution()`. The user defined function `FUN` can take
 any form of f(x) where x is a vector of diameters of length 1 for every
 mL of volume of that branch size class. See Details for recommended values
 for `FUN`.
 #Details
 Values of central tendency are recommended, but not variance since the
 weighted means are simulated.
}
\details{
Recommended values of `FUN` are:

 Mean
 FUN = function(x) mean(x)

 Median
 FUN = function(x) median(x)

 Skewness
 FUN = function(x) 3*(mean(x) - median(x)) / sd(x)
}
\examples{
qsm_file = system.file("extdata", "tree_0744_qsm.txt", package='tReeTraits')
qsm = load_qsm(qsm_file)
branch_distribution = branch_size_distribution(qsm, plot=TRUE)
print(branch_distribution)

#volume-weighted mean
branch_volume_weighted_stats(qsm, FUN = function(x) mean(x))

#volume-weighted median
branch_volume_weighted_stats(qsm, FUN = function(x) median(x))

# volume-weighted skewness
branch_volume_weighted_stats(qsm, FUN = function(x) 3*(mean(x) - median(x)) / sd(x))
}
