% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_point_cloud.R
\name{get_height}
\alias{get_height}
\title{Extract height from  `LAS` object representing segmented tree.}
\usage{
get_height(las, quantiles = c(0, 1))
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing
individually segmented tree}

\item{quantiles}{Z quantiles at which ground level and highest point
are measured. Values in the interval (0,1) are recommended to trim
random noise.}
}
\value{
A named numeric vector with element `height` (m).
}
\description{
Function to extract height from LAS object. Function calculates
difference between two specified quantiles from the `Z` attribute.
}
\examples{
library(lidR)
las = readLAS(system.file("extdata", "tree_0744.laz", package="tReeTraits"))
las = clean_las(las)
print(get_height(las))
}
