% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_point_cloud.R
\name{voxel_hull_2D}
\alias{voxel_hull_2D}
\title{Returns an `sf`representing the vertical crown area from voxelization}
\usage{
voxel_hull_2D(las, resolution = 0.1, angle = 0)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing
the CROWN of a tree. Crowns must be segmented using [segment_crown()].}

\item{resolution}{numeric - resolution of voxelization}

\item{angle}{numeric - in degrees, rotation angle about Z axis.}
}
\value{
An `sf` polygon representing the voxel-based vertical
crown hull.
}
\description{
This function generates an `sf` object representing th vertical crown area
of a `LAS` object by voxelizing a 2D vertical projection.
}
\examples{
las = lidR::readLAS(system.file("extdata", "tree_0744.laz", package="tReeTraits"))
las = clean_las(las)
cbh = get_crown_base(las, threshold=0.25, sustain=2)
las = segment_crown(las, cbh)
get_crown_volume_voxel(las)
get_crown_volume_alpha(las)
sf::st_area(convex_hull_2D(las)) #profile area, convex hull
sf::st_area(voxel_hull_2D(las)) #profile area, voxel hull
get_lacunarity(las)
}
