% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_expand_grid.R
\name{learner_expand_grid}
\alias{learner_expand_grid}
\title{Construct learners from a grid of parameters}
\usage{
learner_expand_grid(fun, args, names = TRUE, params = FALSE)
}
\arguments{
\item{fun}{(function) A function that returns a \link{learner}.}

\item{args}{(list) Parameters that generate a grid of parameters with
\link{expand.list}, where the set of parameters are then passed on to \code{fun}.}

\item{names}{(logical or character) If FALSE, then return a list without
names. If TRUE, a named list is returned (see details).}

\item{params}{(logical) If FALSE, then no information about the parameters
defined by \code{args} are added to the names of the returned list.}
}
\value{
list
}
\description{
Construct learners from a grid of parameters
}
\examples{
lrs <- learner_expand_grid(
  learner_xgboost,
  list(formula = Sepal.Length ~ ., eta = c(0.2, 0.5, 0.3))
)
lrs # use info of constructed learner as names

lrs <- learner_expand_grid(
  learner_xgboost,
  list(formula = Sepal.Length ~ ., eta = c(0.2, 0.5, 0.3)),
  names = "xgboost"
)
names(lrs) # use xgboost instead of info field for names

lrs <- learner_expand_grid(
  learner_xgboost,
  list(formula = Sepal.Length ~ ., eta = c(0.2, 0.5, 0.3)),
  names = "xgboost",
  params = TRUE
)
names(lrs) # also add parameters to names

lrs <- learner_expand_grid(
  learner_xgboost,
  list(formula = Sepal.Length ~ ., eta = c(0.2, 0.5, 0.3)),
  names = FALSE
)
names(lrs) # unnamed list since names = FALSE
}
