% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_path_target.R
\name{tar_path_target}
\alias{tar_path_target}
\title{Identify the file path where the current target will be stored.}
\usage{
tar_path_target(
  name = NULL,
  default = NA_character_,
  create_dir = FALSE,
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{name}{Symbol, name of a target.
If \code{NULL}, \code{tar_path_target()} returns the path of the target currently
running in a pipeline.}

\item{default}{Character, value to return if \code{tar_path_target()}
is called on its own outside a \code{targets} pipeline.
Having a default lets users run things without \code{\link[=tar_make]{tar_make()}},
which helps peel back layers of code and troubleshoot bugs.}

\item{create_dir}{Logical of length 1,
whether to create \code{dirname(tar_path_target())} in
\code{tar_path_target()} itself.
This is useful if you are writing to \code{tar_path_target()} from inside a
\code{storage = "none"} target and need the parent directory of the file
to exist.}

\item{store}{Character of length 1,
path to the data store if \code{tar_path_target()}
is called outside a running pipeline. If \code{tar_path_target()} is called
inside a running pipeline, this argument is ignored
and actual the path to the running pipeline's data store
is used instead.}
}
\value{
Character string, the file path where the target currently running
will be stored. This path is not always known or available in advance,
it depends on the \code{format} and \code{repository} settings.

If \code{format} is not \code{"file"} and \code{repository} is \code{"local"} (default)
then \code{tar_path_target()} returns \code{"STORE/objects/YOUR_TARGET"},
where \code{STORE} is the value of \code{tar_config_get("store")} and
\code{YOUR_TARGET} is the name of your target.

Otherwise, if \code{format} is \code{"file"}, then the return value is
\code{NA_character_} because \code{targets} does not control where
those files are stored.

Otherwise, if \code{format} is not \code{"file"} and \code{repository} is
not \code{"local"}, then \code{tar_path_target()} returns
the temporary staging path where the data is stored
before it is uploaded to a remote repository.
Remote repositories vary so widely that the eventual final location
cannot always be known, but all remote repositories use staging
files that \code{targets} knows about.

If not called from inside a running target,
\code{tar_path_target(name = your_target)} just returns
\code{"STORE/objects/your_target"}.
}
\description{
Identify the file path where the current target will be stored
locally on disk.
Designed to be called inside the command of a target currently
running in a pipeline.
See the "Value" section for specifics because the return
value depends on the \code{format} and \code{repository} settings.
}
\examples{
tar_path_target()
tar_path_target(your_target)
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script(tar_target(returns_path, tar_path_target()), ask = FALSE)
tar_make()
tar_read(returns_path)
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_active}()},
\code{\link{tar_backoff}()},
\code{\link{tar_call}()},
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_described_as}()},
\code{\link{tar_envir}()},
\code{\link{tar_format_get}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path}()},
\code{\link{tar_path_script}()},
\code{\link{tar_path_script_support}()},
\code{\link{tar_path_store}()},
\code{\link{tar_source}()},
\code{\link{tar_store}()},
\code{\link{tar_unblock_process}()}
}
\concept{utilities}
