% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_dict.R
\name{search_dict}
\alias{search_dict}
\title{Exact n-gram matcher (vector of terms)}
\usage{
search_dict(corpus, by = c("doc_id"), terms, n_min = 1, n_max = 5)
}
\arguments{
\item{corpus}{The text data (data frame or data.table with \code{text} and \code{by} columns).}

\item{by}{Identifier columns (e.g. \code{c("doc_id", "sentence_id")}).}

\item{terms}{A character vector of terms/variants to find (e.g. \code{c("United States", "R Project")}).}

\item{n_min}{Integer. Minimum n-gram size (default 1).}

\item{n_max}{Integer. Maximum n-gram size (default 5).}
}
\value{
A data.table with \code{id}, \code{start}, \code{end}, \code{n}, \code{ngram}, \code{term} (the matched term from \code{terms}).
}
\description{
Find a long list of multi-word expressions (MWEs) or terms without regex
overhead or partial-match risks. Tokenize corpus, build n-grams, then exact
join against \code{terms}. Word boundaries are respected by design. For
categories (e.g. term = "R Project", category = "Software"), left_join your
metadata onto the result using \code{ngram} or \code{term} as key.
}
\examples{
corpus <- data.frame(doc_id = "1", text = "Gen Z and Millennials use social media.")
search_dict(corpus, by = "doc_id", terms = c("Gen Z", "Millennials", "social media"))
}
