% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsemodel.R
\name{parse_model}
\alias{parse_model}
\title{Converts an R model object into a parsed model}
\usage{
parse_model(model)
}
\arguments{
\item{model}{An R model object.}
}
\value{
A parsed model object with class \code{parsed_model} and a model-specific
subclass (e.g., \code{pm_xgb}, \code{pm_tree}, \code{pm_regression}). The object contains:
\itemize{
\item \verb{$general}: List with model metadata including \code{model} (model type),
\code{type} (used for S3 dispatch), \code{version} (parsed model format version),
and model-specific parameters.
\item Model-specific fields containing coefficients, tree structures, etc.
}
}
\description{
Parses a fitted R model's structure and extracts the components needed to
create a dplyr formula for prediction. The parsed model can be serialized
(e.g., saved to YAML) and later used to generate predictions without the
original model object.
}
\section{Parsed model versions}{


The \verb{$general$version} field indicates the parsed model format:
\itemize{
\item \strong{Version 1}: Original format. Linear models store coefficients in a
data frame. Tree models use flat \code{case_when()} expressions where all leaf
conditions are at the same level.
\item \strong{Version 2}: Improved coefficient storage for linear models (lm, earth).
Tree models still use flat \code{case_when()}.
\item \strong{Version 3}: Current format. Tree models (rpart, ranger, randomForest,
xgboost, lightgbm, catboost, partykit, cubist) use nested \code{case_when()}
expressions that mirror the tree structure. This produces more efficient
SQL and R code because conditions are evaluated hierarchically rather than
checking all leaf paths.
}

When loading a parsed model saved with an older version, tidypredict
automatically uses the appropriate formula builder for backwards
compatibility.
}

\section{Model types}{


Each parsed model has a type that determines the S3 class used for dispatch:
\itemize{
\item \code{pm_regression}: Linear models (lm, glm, earth, glmnet)
\item \code{pm_tree}: Single trees and forests (rpart, partykit, ranger, randomForest,
cubist)
\item \code{pm_xgb}: XGBoost gradient boosting models
\item \code{pm_lgb}: LightGBM gradient boosting models
\item \code{pm_catboost}: CatBoost gradient boosting models
}
}

\examples{
library(dplyr)
df <- mutate(mtcars, cyl = paste0("cyl", cyl))
model <- lm(mpg ~ wt + cyl * disp, offset = am, data = df)
parse_model(model)
}
