% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.tna_clustering}
\alias{print.tna_clustering}
\title{Print the Results of Clustering}
\usage{
\method{print}{tna_clustering}(x, ...)
}
\arguments{
\item{x}{A \code{tna_clustering} object.}

\item{...}{Additional arguments passed to the generic print method.}
}
\value{
\code{x} (invisibly).
}
\description{
Print the Results of Clustering
}
\examples{
data <- data.frame(
  T1 = c("A", "B", "A", "C", "A", "B"),
  T2 = c("B", "A", "B", "A", "C", "A"),
  T3 = c("C", "C", "A", "B", "B", "C")
)

# PAM clustering with optimal string alignment (default)
result <- cluster_sequences(data, k = 2)
print(result)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_reliability}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_reliability}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reliability}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
