% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/averageresponse.R
\name{averageresponse}
\alias{averageresponse}
\title{Average response variable}
\usage{
averageresponse(
  dataset,
  Conc,
  Response,
  IDcols = NULL,
  list_obj = NULL,
  quiet = FALSE
)
}
\arguments{
\item{dataset}{A dataframe, containing the columns `Conc` and `Response`.}

\item{Conc}{Bare (unquoted) column name in `dataset` that groups the
`Response` variable.}

\item{Response}{Bare (unquoted) column name in `dataset` containing
the response variable.}

\item{IDcols}{Character. Columns given as a vector used in the
identification of data. These columns are preserved in the modified
`dataset` with the first non-blank value. These values should be
identical within observations grouped by `Conc`.}

\item{list_obj}{Optional. List object used for integration with
[runtoxdrc()].}

\item{quiet}{Logical. Indicates if results should be hidden. Defaults
to FALSE.}
}
\value{
A collapsed `dataset` with one row for each level of `Conc`.
 If `list_obj` is provided, returns this within a list as
 `list_obj$dataset`, along with an unmodified copy as
 `list_obj$pre_average_dataset`.
}
\description{
`averageresponse()` averages a given response variable by the
 experimental group, such as concentration or exposure length.
}
\examples{
averageresponse(
     dataset = toxresult,
     Conc = Conc,
     Response = RFU,
     IDcols = c("TestID", "Test_Number", "Dye", "Type", "Replicate"),
   )

}
