% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_runtoxdrc.R
\name{toxdrc_toxicity}
\alias{toxdrc_toxicity}
\title{Toxicity configuration for for the runtoxdrc pipeline.}
\usage{
toxdrc_toxicity(
  toxic.lvl = 0.7,
  toxic.type = c("relative", "absolute"),
  toxic.direction = c("below", "above"),
  comp.group = 0,
  target.group = NULL
)
}
\arguments{
\item{toxic.lvl}{Numeric. Cutoff point to determine if modelling occurs.
Defaults to 0.7.}

\item{toxic.type}{Character. Indicates if `effect` is `"relative"` to
`reference group` or an `"absolute"` value. Defaults to relative.}

\item{toxic.direction}{Character. Indicates if an effect occurs `"below"`
or `"above"`. Defaults to below.}

\item{comp.group}{Label used for reference group.}

\item{target.group}{Optional. Limits the compairison to certain
exposure conditions.}
}
\value{
A named list containing toxicity determination settings for use
 in [runtoxdrc()].
}
\description{
Defines how toxicity is determined for model fitting.
}
\examples{
toxdrc_toxicity(toxic.lvl = 0.5, toxic.direction = "above")

}
\seealso{
[config_runtoxdrc], [runtoxdrc()], [checktoxicity()]
}
