% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision_plot.R
\name{plot.precision_study}
\alias{plot.precision_study}
\alias{autoplot.precision_study}
\title{Plot method for precision_study objects}
\usage{
\method{plot}{precision_study}(
  x,
  type = c("variance", "cv", "precision"),
  show_ci = TRUE,
  colors = NULL,
  title = NULL,
  ...
)

\method{autoplot}{precision_study}(
  object,
  type = c("variance", "cv", "precision"),
  show_ci = TRUE,
  colors = NULL,
  title = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{precision_study}.}

\item{type}{Character; type of plot to create:
\itemize{
\item \code{"variance"} (default): Bar chart showing variance components
as percentage of total variance
\item \code{"cv"}: CV profile across samples (requires multi-sample data)
\item \code{"precision"}: Forest plot of precision estimates with CIs
}}

\item{show_ci}{Logical; if \code{TRUE} (default), displays confidence intervals
where applicable.}

\item{colors}{Character vector of colors for the plot elements. If \code{NULL},
uses a default color palette.}

\item{title}{Character; plot title. If \code{NULL} (default), generates an
automatic title.}

\item{...}{Additional arguments (currently ignored).}

\item{object}{An object of class \code{precision_study}.}
}
\value{
A \code{ggplot} object that can be further customized.
}
\description{
Creates visualizations for precision study results. Multiple plot types
are available: variance component chart, CV profile across samples,
and precision estimates summary.
}
\details{
\strong{Variance component chart} (\code{type = "variance"}):
Displays the proportion of total variance attributable to each source
(between-day, between-run, error/repeatability). Helps identify which
factors contribute most to measurement variability.

\strong{CV profile} (\code{type = "cv"}):
For multi-sample studies, displays how CV varies across concentration
levels. Typically CV is higher at low concentrations. Requires data
from multiple samples/levels.

\strong{Precision summary} (\code{type = "precision"}):
Forest plot showing precision estimates (repeatability, intermediate
precision, reproducibility) with confidence intervals.
}
\examples{
# Create example data
set.seed(42)
prec_data <- data.frame(
  day = rep(1:5, each = 6),
  run = rep(rep(1:2, each = 3), 5),
  value = rnorm(30, mean = 100, sd = 5)
)
prec_data$value <- prec_data$value + rep(rnorm(5, 0, 3), each = 6)

prec <- precision_study(prec_data, value = "value", day = "day", run = "run")

# Variance component chart (default)
plot(prec)
plot(prec, type = "variance")

# Precision estimates with CIs
plot(prec, type = "precision")

}
\seealso{
\code{\link[=precision_study]{precision_study()}} for performing the analysis,
\code{\link[=summary.precision_study]{summary.precision_study()}} for detailed results
}
