% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvi_npmm.R
\name{cvi_npmm}
\alias{cvi_npmm}
\title{Collapsed variational inference for non-parametric Bayesian mixture models}
\usage{
cvi_npmm(
  X,
  variational_params,
  prior_shape_alpha,
  prior_rate_alpha,
  post_shape_alpha,
  post_rate_alpha,
  prior_mean_eta,
  post_mean_eta,
  log_prob_matrix = NULL,
  maxit = 100,
  n_inits = 5,
  Seed = NULL,
  parallel = FALSE,
  covariance_type = "full",
  fixed_variance = FALSE,
  cluster_specific_covariance = TRUE,
  variance_prior_type = c("IW", "decomposed", "sparse", "off-diagonal normal"),
  ...
)
}
\arguments{
\item{X}{input data as a matrix}

\item{variational_params}{number of clusters in the variational distribution}

\item{prior_shape_alpha}{shape parameter of Gamma prior for the DP
concentration parameter alpha. Default is 0.001}

\item{prior_rate_alpha}{rate parameter of Gamma prior for the DP
concentration parameter alpha. Default is 0.001}

\item{post_shape_alpha}{initial value for posterior update of shape parameter
for alpha. Default is 0.001}

\item{post_rate_alpha}{initial value for posterior update of ratee parameter
for alpha. Default is 0.001}

\item{prior_mean_eta}{mean vector of MVN prior for the DP mean parameters.
Default is zero vector}

\item{post_mean_eta}{initial value of posterior update for the DP mean
parameter}

\item{log_prob_matrix}{logarithm of cluster allocation probability matrix.
Default is NULL}

\item{maxit}{maximum number of iterations. Default is 100}

\item{n_inits}{Number of random initialisations if log_prob_matrix and other
case-specific hyperparameters are NULL. Default is 5}

\item{Seed}{Seeds for random initialisation; either a vector of n_inits
integers or NULL. Default is NULL.}

\item{parallel}{Logical input for parallelisation. Default is FALSE}

\item{covariance_type}{covariance matrix is considered diagonal or full.
Default is 'full'}

\item{fixed_variance}{covariance matrix of the data is considered known (fixed)
or unknown. Default is FALSE}

\item{cluster_specific_covariance}{covariance matrix is specific to a cluster
allocation or it is same over all cluster choices. Default is TRUE}

\item{variance_prior_type}{For unknown and full covariance matrix, choice of
matrix prior is either Inverse-Wishart ('IW') or Cholesky-decomposed
('decomposed'). For unknown, full and cluster-specific covariance matrix,
choice of matrix prior is either Inverse-Wishart ('IW'), element-wise Gamma
and Laplace distributed ('sparse') or element-wise Gamma and Normal
distributed ('off-diagonal normal')}

\item{...}{additional parameters, further details given below}
}
\value{
\verb{[vimixr()]} returns a \code{list} with the following elements:
\itemize{
\item \code{alpha}: posterior DP concentration parameter
\item \verb{Cluster number}: number of clusters from posterior probability allocation matrix
\item \verb{Cluster Proportion}: cluster proportions from posterior probability allocation matrix
\item \verb{log Probability matrix}: log of posterior probability allocation matrix
\item \code{ELBO}: Optimisation of the ELBO function
\item \code{Iterations}: Number of iterations required for convergence
\item \code{PCA_viz}: A PCA \verb{[ggplot2]} plot to visualize the clustering of data based on cluster labels
\item \code{ELBO_viz}: A line \verb{[ggplot2]} plot to visualize the ELBO optimisation
}
}
\description{
Collapsed variational inference for non-parametric Bayesian mixture models
}
\details{
The following models are supported in \code{vimixr}, listing their
required input arguments in \code{...} when calling \code{cvi_npmm()}: \itemize{
\item \strong{Known covariance} \itemize{
\item \emph{diagonal covariance} We need the following additional
arguments: \describe{
\item{\code{cov_data}: a non-negative diagonal matrix, representing
the covariance of the data}{}
\item{\code{prior_precision_scalar_eta}: a non-negative scalar,
representing the precision prior for the DP mean parameters}{}
\item{\code{post_precision_scalar_eta}: initial value for the
posterior update of precision for the DP mean parameters}{}
}
\item \emph{full covariance} We need the following additional
arguments: \describe{
\item{\code{cov_data}: a positive definite matrix, representing
the covariance of the data}{}
\item{\code{prior_cov_eta}: a positive definite matrix,
representing the covariance prior for the DP mean parameters}{}
\item{\code{post_cov_eta}: initial value for the
posterior update of covariance for the DP mean parameters}{}
}
}
\item \strong{Unknown covariance (Global)} \itemize{
\item \emph{diagonal covariance} We need the following additional
arguments: \describe{
\item{\code{prior_shape_scalar_cov}: a non-negative scalar, representing
the shape parameter of Gamma prior for the precision}{}
\item{\code{prior_rate_scalar_cov}: a non-negative scalar, representing
the rate parameter of Gamma prior for the precision}{}
\item{\code{post_shape_scalar_cov}: initial value for posterior update of
precision shape parameter}{}
\item{\code{post_rate_scalar_cov}: initial value for posterior update of
precision rate parameter}{}
\item{\code{prior_precision_scalar_eta}: a non-negative scalar,
representing the precision prior for the DP mean parameters}{}
\item{\code{post_precision_scalar_eta}: initial value for the
posterior update of precision for the DP mean parameters}{}
}
\item \emph{Inverse-Wishart} We need the following additional
arguments: \describe{
\item{\code{prior_df_cov}: a scalar as the degree of freedom parameter
of the Inverse-Wishart prior, Default value D+2}{}
\item{\code{prior_scale_cov}: positive-definite matrix as the scale
parameter of the Inverse-Wishart prior}{}
\item{\code{post_df_cov}: initial value for the posterior update of
degree of freedom}{}
\item{\code{post_scale_cov}: initial value for the posterior update of
scale matrix}{}
\item{\code{prior_cov_eta}: a positive definite matrix,
representing the covariance prior for the DP mean parameters}{}
\item{\code{post_cov_eta}: initial value for the
posterior update of covariance for the DP mean parameters}{}
}
\item \emph{Cholesky-decomposition} We need the following additional
arguments: \describe{
\item{\code{prior_shape_diag_decomp}: a non-negative scalar as the shape
parameter of Gamma prior for diagonal elements of the
Cholesly-decomposed matrix}{}
\item{\code{prior_rate_diag_decomp}: a non-negative scalar as the rate
parameter of Gamma prior for diagonal elements of the
Cholesly-decomposed matrix}{}
\item{\code{prior_mean_offdiag_decomp}: a scalar as the mean
parameter of Normal prior for off-diagonal elements of the
Cholesly-decomposed matrix}{}
\item{\code{prior_var_offdiag_decomp}: a non-negative scalar as the variance
parameter of Normal prior for off-diagonal elements of the
Cholesly-decomposed matrix}{}
\item{\code{post_shape_diag_decomp}: initial value for posterior update
of the shape parameter for diagonal elements}{}
\item{\code{post_rate_diag_decomp}: initial value for posterior update
of the rate parameter for diagonal elements}{}
\item{\code{post_mean_offdiag_decomp}: initial value for posterior update
of the mean parameter for off-diagonal elements}{}
\item{\code{post_var_offdiag_decomp}: initial value for posterior update
of the variance parameter for off-diagonal elements}{}
\item{\code{prior_cov_eta}: a positive definite matrix,
representing the covariance prior for the DP mean parameters}{}
\item{\code{post_cov_eta}: initial value for the
posterior update of covariance for the DP mean parameters}{}}
}
\item \strong{Unknown covariance (cluster-specific)} \itemize{
\item \emph{Inverse Wishart} We need the following additional
arguments: \describe{
\item{\code{prior_df_cs_cov}: a vector representing degree of freedom
parameters for each cluster-specific Inverse-Wishart prior}{}
\item{\code{prior_scale_cs_cov}: an array of positive-definite matrices
representing scale matrix parameters for each cluster-specific
Inverse-Wishart prior}{}
\item{\code{post_df_cs_cov}: initial value for posterior update of the
degree of freedom parameters}{}
\item{\code{post_scale_cs_cov}: initial value for posterior update of
the scale matrix parameters}{}
\item{\code{scaling_cov_eta}: a non-negative scaling factor for
covariance matrix of the DP mean parameters}{}
}
\item \emph{Element-wise Gamma and Laplace prior} We need the following
additional arguments: \describe{
\item{\code{prior_shape_d_cs_cov}: a non-negative vector as shape
parameters for cluster-specific Gamma priors of the diagonal
elements}{}
\item{\code{prior_rate_d_cs_cov}: a non-negative matrix as rate
parameter for cluster-specific Gamma prior of the diagonal
elements}{}
\item{\code{prior_var_offd_cs_cov}: a non-negative vector as variance
parameter for cluster-specific Laplace priors of the off-diagonal
elements}{}
\item{\code{post_shape_d_cs_cov}: initial value for posterior update of
the diagonal shape parameters}{}
\item{\code{post_rate_d_cs_cov}: initial value for posterior update of
the diagonal rate parameters}{}
\item{\code{post_var_offd_cs_cov}: initial value for posterior update of
the off-diagonal variance parameters}{}
\item{\code{scaling_cov_eta}: a non-negative scaling factor for
covariance matrix of the DP mean parameters}{}
}
\item \emph{Element-wise Gamma and Normal prior} We need the following
additional arguments: \describe{
\item{\code{prior_shape_d_cs_cov}: a non-negative vector as shape
parameters for cluster-specific Gamma priors of the diagonal
elements}{}
\item{\code{prior_rate_d_cs_cov}: a non-negative matrix as rate
parameter for cluster-specific Gamma prior of the diagonal
elements}{}
\item{\code{prior_var_offd_cs_cov}: a non-negative scalar as variance
parameter for cluster-specific Normal priors of the off-diagonal
elements}{}
\item{\code{post_shape_d_cs_cov}: initial value for posterior update of
the diagonal shape parameters}{}
\item{\code{post_rate_d_cs_cov}: initial value for posterior update of
the diagonal rate parameters}{}
\item{\code{post_mean_offd_cs_cov}: initial value for posterior update of
the off-diagonal mean parameters}{}
\item{\code{scaling_cov_eta}: a non-negative scaling factor for
covariance matrix of the DP mean parameters}{}
}
}
}
}
\examples{

X <- rbind(matrix(rnorm(100, m=0, sd=0.5), ncol=2),
           matrix(rnorm(100, m=3, sd=0.5), ncol=2))

#for fixed-diagonal
res <- cvi_npmm(X, variational_params = 20, prior_shape_alpha = 0.001,
         prior_rate_alpha = 0.001, post_shape_alpha = 0.001,
         post_rate_alpha = 0.001, prior_mean_eta = matrix(0, 1, ncol(X)),
         post_mean_eta = matrix(0.001, 20, ncol(X)),
         log_prob_matrix = t(apply(matrix(-3, nrow(X), 20), 1,
                             function(x){x/sum(x)})), maxit = 100,
         fixed_variance = TRUE, covariance_type = "diagonal",
         prior_precision_scalar_eta = 0.001,
         post_precision_scalar_eta = matrix(0.001, 20, 1),
         cov_data = diag(ncol(X)))
 summary(res)
 plot(res)

}
