% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inbreed.R
\name{inbreed}
\alias{inbreed}
\title{Calculate inbreeding coefficients}
\usage{
inbreed(ped, ...)
}
\arguments{
\item{ped}{A \code{tidyped} object.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A \code{tidyped} object with an additional column \strong{f}.
}
\description{
\code{inbreed} function calculates the inbreeding coefficients for all individuals in a tidied pedigree.
}
\details{
This function takes a pedigree tidied by the \code{\link{tidyped}} function and calculates the inbreeding coefficients using optimized C++ code based on the Meuwissen & Luo (1992) algorithm. It is the core engine used by both \code{tidyped(..., inbreed = TRUE)} and \code{pedmat(..., method = "f")}, ensuring consistent results across the package. It is significantly faster than standard R implementations for large pedigrees.
}
